/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.base.raft;

import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.DataCfg;
import io.zeebe.distributedlog.StorageConfigurationManager;
import io.zeebe.distributedlog.impl.LogstreamConfig;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.sched.Actor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class RaftPersistentConfigurationManagerService
implements Service<StorageConfigurationManager> {
    private StorageConfigurationManager service;
    private BrokerCfg configuration;

    public RaftPersistentConfigurationManagerService(BrokerCfg configuration) {
        this.configuration = configuration;
    }

    public void start(ServiceStartContext startContext) {
        DataCfg dataConfiguration = this.configuration.getData();
        for (String directory : dataConfiguration.getDirectories()) {
            File configDirectory = new File(directory);
            if (configDirectory.exists()) continue;
            try {
                configDirectory.getParentFile().mkdirs();
                Files.createDirectory(configDirectory.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create directory " + configDirectory, e);
            }
        }
        this.service = new StorageConfigurationManager(this.configuration.getData().getDirectories(), this.configuration.getData().getLogSegmentSize(), this.configuration.getData().getIndexBlockSize());
        LogstreamConfig.putConfig((String)String.valueOf(this.configuration.getCluster().getNodeId()), (StorageConfigurationManager)this.service);
        startContext.async(startContext.getScheduler().submitActor((Actor)this.service));
    }

    public void stop(ServiceStopContext stopContext) {
        stopContext.async(this.service.close());
    }

    public StorageConfigurationManager get() {
        return this.service;
    }
}

