/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.base.topology;

import io.zeebe.transport.SocketAddress;
import org.agrona.collections.IntHashSet;

public class NodeInfo {
    private final int nodeId;
    private final SocketAddress commandApiAddress;
    private final IntHashSet leaders = new IntHashSet();
    private final IntHashSet followers = new IntHashSet();

    public NodeInfo(int nodeId, SocketAddress commandApiAddress) {
        this.nodeId = nodeId;
        this.commandApiAddress = commandApiAddress;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public SocketAddress getCommandApiAddress() {
        return this.commandApiAddress;
    }

    public IntHashSet getLeaders() {
        return this.leaders;
    }

    public boolean addLeader(int partitionId) {
        return this.leaders.add(partitionId);
    }

    public boolean removeLeader(int partitionId) {
        return this.leaders.remove(partitionId);
    }

    public IntHashSet getFollowers() {
        return this.followers;
    }

    public boolean addFollower(int partitionId) {
        return this.followers.add(partitionId);
    }

    public boolean removeFollower(int partitionId) {
        return this.followers.remove(partitionId);
    }

    public String toString() {
        return String.format("Node{nodeId=%d, commandApi=%s}", this.nodeId, this.commandApiAddress);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.commandApiAddress == null ? 0 : this.commandApiAddress.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeInfo other = (NodeInfo)obj;
        if (this.commandApiAddress == null) {
            return other.commandApiAddress == null;
        }
        return this.commandApiAddress.equals((Object)other.commandApiAddress);
    }
}

