/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.base.topology;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.clustering.base.partitions.RaftState;
import io.zeebe.broker.clustering.base.topology.NodeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.IntHashSet;
import org.slf4j.Logger;

public class Topology {
    private static final Logger LOG = Loggers.CLUSTERING_LOGGER;
    private final NodeInfo local;
    private final IntHashSet partitions = new IntHashSet();
    private final List<NodeInfo> members = new ArrayList<NodeInfo>();
    private final Int2ObjectHashMap<NodeInfo> partitionLeaders = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<List<NodeInfo>> partitionFollowers = new Int2ObjectHashMap();
    private final int clusterSize;
    private final int partitionsCount;
    private final int replicationFactor;

    public Topology(NodeInfo localBroker, int clusterSize, int partitionsCount, int replicationFactor) {
        this.local = localBroker;
        this.clusterSize = clusterSize;
        this.partitionsCount = partitionsCount;
        this.replicationFactor = replicationFactor;
        this.addMember(localBroker);
    }

    public NodeInfo getLocal() {
        return this.local;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public NodeInfo getMember(int nodeId) {
        NodeInfo member = null;
        for (int i = 0; i < this.members.size() && member == null; ++i) {
            NodeInfo current = this.members.get(i);
            if (nodeId != current.getNodeId()) continue;
            member = current;
        }
        return member;
    }

    public List<NodeInfo> getMembers() {
        return this.members;
    }

    public NodeInfo getLeader(int partitionId) {
        return (NodeInfo)this.partitionLeaders.get(partitionId);
    }

    public List<NodeInfo> getFollowers(int partitionId) {
        return (List)this.partitionFollowers.getOrDefault((Object)partitionId, Collections.emptyList());
    }

    public IntHashSet getPartitions() {
        return this.partitions;
    }

    public boolean addMember(NodeInfo member) {
        if (!this.members.contains(member)) {
            LOG.debug("Adding {} to list of known members", (Object)member);
            return this.members.add(member);
        }
        return false;
    }

    public void removeMember(NodeInfo member) {
        int partitionId;
        LOG.debug("Removing {} from list of known members", (Object)member);
        IntHashSet.IntIterator intIterator = member.getFollowers().iterator();
        while (intIterator.hasNext()) {
            partitionId = (Integer)intIterator.next();
            List followers = (List)this.partitionFollowers.get(partitionId);
            if (followers == null) continue;
            followers.remove(member);
        }
        intIterator = member.getLeaders().iterator();
        while (intIterator.hasNext()) {
            partitionId = (Integer)intIterator.next();
            this.partitionLeaders.remove(partitionId);
        }
        this.members.remove(member);
    }

    public void updatePartition(int partitionId, NodeInfo member, RaftState state) {
        ArrayList<NodeInfo> followers = (ArrayList<NodeInfo>)this.partitionFollowers.get(partitionId);
        this.partitions.add(partitionId);
        LOG.debug("Updating partition information for partition {} on {} with state {}", new Object[]{partitionId, member, state});
        if (state != null) {
            switch (state) {
                case LEADER: {
                    if (followers != null) {
                        followers.remove(member);
                    }
                    this.partitionLeaders.put(partitionId, (Object)member);
                    member.removeFollower(partitionId);
                    member.addLeader(partitionId);
                    break;
                }
                case FOLLOWER: {
                    if (member.equals(this.partitionLeaders.get(partitionId))) {
                        this.partitionLeaders.remove(partitionId);
                    }
                    if (followers == null) {
                        followers = new ArrayList<NodeInfo>();
                        this.partitionFollowers.put(partitionId, followers);
                    }
                    if (!followers.contains(member)) {
                        followers.add(member);
                    }
                    member.removeLeader(partitionId);
                    member.addFollower(partitionId);
                }
            }
        }
    }
}

