/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.base.topology;

import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.Member;
import io.atomix.core.Atomix;
import io.atomix.utils.event.EventListener;
import io.zeebe.broker.Loggers;
import io.zeebe.broker.clustering.base.partitions.RaftState;
import io.zeebe.broker.clustering.base.topology.NodeInfo;
import io.zeebe.broker.clustering.base.topology.Topology;
import io.zeebe.broker.clustering.base.topology.TopologyManager;
import io.zeebe.broker.clustering.base.topology.TopologyMemberListener;
import io.zeebe.broker.clustering.base.topology.TopologyPartitionListener;
import io.zeebe.broker.system.configuration.ClusterCfg;
import io.zeebe.protocol.impl.data.cluster.BrokerInfo;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.LogUtil;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.agrona.collections.IntHashSet;
import org.slf4j.Logger;

public class TopologyManagerImpl
extends Actor
implements TopologyManager,
ClusterMembershipEventListener {
    private static final Logger LOG = Loggers.CLUSTERING_LOGGER;
    private final Topology topology;
    private final Atomix atomix;
    private final BrokerInfo distributionInfo;
    private final List<TopologyMemberListener> topologyMemberListeners = new ArrayList<TopologyMemberListener>();
    private final List<TopologyPartitionListener> topologyPartitionListeners = new ArrayList<TopologyPartitionListener>();

    public TopologyManagerImpl(Atomix atomix, NodeInfo localBroker, ClusterCfg clusterCfg) {
        this.atomix = atomix;
        this.topology = new Topology(localBroker, clusterCfg.getClusterSize(), clusterCfg.getPartitionsCount(), clusterCfg.getReplicationFactor());
        this.distributionInfo = new BrokerInfo(localBroker.getNodeId(), this.topology.getPartitionsCount(), this.topology.getClusterSize(), this.topology.getReplicationFactor());
        this.distributionInfo.setApiAddress("command", localBroker.getCommandApiAddress().toString());
        this.publishTopologyChanges();
    }

    protected void onActorStarted() {
        this.atomix.getMembershipService().addListener((EventListener)this);
        this.atomix.getMembershipService().getMembers().forEach(m -> this.event(new ClusterMembershipEvent(ClusterMembershipEvent.Type.MEMBER_ADDED, m)));
    }

    public String getName() {
        return "topology";
    }

    public void updateRole(RaftState state, int partitionId) {
        this.actor.call(() -> {
            NodeInfo memberInfo = this.topology.getLocal();
            this.updatePartition(partitionId, memberInfo, state);
            this.publishTopologyChanges();
        });
    }

    public void updatePartition(int partitionId, NodeInfo member, RaftState raftState) {
        this.topology.updatePartition(partitionId, member, raftState);
        this.notifyPartitionUpdated(partitionId, member);
    }

    public void event(ClusterMembershipEvent clusterMembershipEvent) {
        Member eventSource = (Member)clusterMembershipEvent.subject();
        LOG.debug("Member {} received event {}", (Object)this.topology.getLocal().getNodeId(), (Object)clusterMembershipEvent);
        BrokerInfo brokerInfo = this.readBrokerInfo(eventSource);
        if (brokerInfo != null && brokerInfo.getNodeId() != this.topology.getLocal().getNodeId()) {
            this.actor.call(() -> {
                switch ((ClusterMembershipEvent.Type)clusterMembershipEvent.type()) {
                    case METADATA_CHANGED: {
                        this.onMetadataChanged(brokerInfo);
                        break;
                    }
                    case MEMBER_ADDED: {
                        this.onMemberAdded(brokerInfo);
                        this.onMetadataChanged(brokerInfo);
                        break;
                    }
                    case MEMBER_REMOVED: {
                        this.onMemberRemoved(brokerInfo);
                    }
                }
            });
        }
    }

    private void onMemberRemoved(BrokerInfo brokerInfo) {
        NodeInfo nodeInfo = this.topology.getMember(brokerInfo.getNodeId());
        if (nodeInfo != null) {
            this.topology.removeMember(nodeInfo);
            this.notifyMemberRemoved(nodeInfo);
        }
    }

    private void onMemberAdded(BrokerInfo brokerInfo) {
        NodeInfo nodeInfo = new NodeInfo(brokerInfo.getNodeId(), SocketAddress.from((String)brokerInfo.getApiAddress("command")));
        if (this.topology.addMember(nodeInfo)) {
            this.notifyMemberAdded(nodeInfo);
        }
    }

    private void onMetadataChanged(BrokerInfo brokerInfo) {
        NodeInfo nodeInfo = this.topology.getMember(brokerInfo.getNodeId());
        brokerInfo.consumePartitions(leaderPartitionId -> {
            this.topology.updatePartition((int)leaderPartitionId, nodeInfo, RaftState.LEADER);
            this.notifyPartitionUpdated((int)leaderPartitionId, nodeInfo);
        }, followerPartitionId -> {
            this.topology.updatePartition((int)followerPartitionId, nodeInfo, RaftState.FOLLOWER);
            this.notifyPartitionUpdated((int)followerPartitionId, nodeInfo);
        });
    }

    private BrokerInfo readBrokerInfo(Member eventSource) {
        BrokerInfo brokerInfo = BrokerInfo.fromProperties((Properties)eventSource.properties());
        if (brokerInfo != null && !this.isStaticConfigValid(brokerInfo)) {
            LOG.error("Static configuration of node {} differs from local node {}", (Object)eventSource.id(), (Object)this.atomix.getMembershipService().getLocalMember().id());
            return null;
        }
        return brokerInfo;
    }

    private boolean isStaticConfigValid(BrokerInfo brokerInfo) {
        return brokerInfo.getNodeId() >= 0 && brokerInfo.getNodeId() < this.topology.getClusterSize() && this.topology.getClusterSize() == brokerInfo.getClusterSize() && this.topology.getPartitionsCount() == brokerInfo.getPartitionsCount() && this.topology.getReplicationFactor() == brokerInfo.getReplicationFactor();
    }

    private void publishTopologyChanges() {
        BrokerInfo distributionInfo = this.createLocalNodeBrokerInfo();
        Properties memberProperties = this.atomix.getMembershipService().getLocalMember().properties();
        BrokerInfo.writeIntoProperties((Properties)memberProperties, (BrokerInfo)distributionInfo);
    }

    private BrokerInfo createLocalNodeBrokerInfo() {
        int partitionId;
        NodeInfo local = this.topology.getLocal();
        this.distributionInfo.clearPartitions();
        IntHashSet.IntIterator intIterator = local.getLeaders().iterator();
        while (intIterator.hasNext()) {
            partitionId = (Integer)intIterator.next();
            this.distributionInfo.addLeaderForPartition(partitionId);
        }
        intIterator = local.getFollowers().iterator();
        while (intIterator.hasNext()) {
            partitionId = (Integer)intIterator.next();
            this.distributionInfo.addFollowerForPartition(partitionId);
        }
        return this.distributionInfo;
    }

    public ActorFuture<Void> close() {
        return this.actor.close();
    }

    @Override
    public void addTopologyMemberListener(TopologyMemberListener listener) {
        this.actor.run(() -> {
            this.topologyMemberListeners.add(listener);
            this.topology.getMembers().forEach(m -> LogUtil.catchAndLog((Logger)LOG, () -> listener.onMemberAdded((NodeInfo)m, this.topology)));
        });
    }

    @Override
    public void removeTopologyMemberListener(TopologyMemberListener listener) {
        this.actor.run(() -> this.topologyMemberListeners.remove(listener));
    }

    @Override
    public void addTopologyPartitionListener(TopologyPartitionListener listener) {
        this.actor.run(() -> {
            this.topologyPartitionListeners.add(listener);
            this.topology.getPartitions().forEach(partitionId -> LogUtil.catchAndLog((Logger)LOG, () -> {
                List<NodeInfo> followers;
                NodeInfo leader = this.topology.getLeader((int)partitionId);
                if (leader != null) {
                    listener.onPartitionUpdated((int)partitionId, leader);
                }
                if ((followers = this.topology.getFollowers((int)partitionId)) != null && !followers.isEmpty()) {
                    followers.forEach(follower -> listener.onPartitionUpdated((int)partitionId, (NodeInfo)follower));
                }
            }));
        });
    }

    @Override
    public void removeTopologyPartitionListener(TopologyPartitionListener listener) {
        this.actor.run(() -> this.topologyPartitionListeners.remove(listener));
    }

    private void notifyMemberAdded(NodeInfo memberInfo) {
        for (TopologyMemberListener listener : this.topologyMemberListeners) {
            LogUtil.catchAndLog((Logger)LOG, () -> listener.onMemberAdded(memberInfo, this.topology));
        }
    }

    private void notifyMemberRemoved(NodeInfo memberInfo) {
        for (TopologyMemberListener listener : this.topologyMemberListeners) {
            LogUtil.catchAndLog((Logger)LOG, () -> listener.onMemberRemoved(memberInfo, this.topology));
        }
    }

    private void notifyPartitionUpdated(int partitionId, NodeInfo member) {
        for (TopologyPartitionListener listener : this.topologyPartitionListeners) {
            LogUtil.catchAndLog((Logger)LOG, () -> listener.onPartitionUpdated(partitionId, member));
        }
    }
}

