/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.base.topology;

import io.atomix.core.Atomix;
import io.zeebe.broker.clustering.base.partitions.Partition;
import io.zeebe.broker.clustering.base.topology.NodeInfo;
import io.zeebe.broker.clustering.base.topology.TopologyManager;
import io.zeebe.broker.clustering.base.topology.TopologyManagerImpl;
import io.zeebe.broker.system.configuration.ClusterCfg;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceGroupReference;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.sched.Actor;

public class TopologyManagerService
implements Service<TopologyManager> {
    private TopologyManagerImpl topologyManager;
    private final ServiceGroupReference<Partition> leaderInstallReference = ServiceGroupReference.create().onAdd((name, partition) -> this.topologyManager.updateRole(partition.getState(), partition.getPartitionId())).build();
    private final ServiceGroupReference<Partition> followerInstallReference = ServiceGroupReference.create().onAdd((name, partition) -> this.topologyManager.updateRole(partition.getState(), partition.getPartitionId())).build();
    private final NodeInfo localMember;
    private final ClusterCfg clusterCfg;
    private final Injector<Atomix> atomixInjector = new Injector();

    public TopologyManagerService(NodeInfo localMember, ClusterCfg clusterCfg) {
        this.localMember = localMember;
        this.clusterCfg = clusterCfg;
    }

    public void start(ServiceStartContext startContext) {
        Atomix atomix = (Atomix)this.atomixInjector.getValue();
        this.topologyManager = new TopologyManagerImpl(atomix, this.localMember, this.clusterCfg);
        startContext.async(startContext.getScheduler().submitActor((Actor)this.topologyManager));
    }

    public void stop(ServiceStopContext stopContext) {
        stopContext.async(this.topologyManager.close());
    }

    public TopologyManager get() {
        return this.topologyManager;
    }

    public ServiceGroupReference<Partition> getLeaderInstallReference() {
        return this.leaderInstallReference;
    }

    public ServiceGroupReference<Partition> getFollowerInstallReference() {
        return this.followerInstallReference;
    }

    public Injector<Atomix> getAtomixInjector() {
        return this.atomixInjector;
    }
}

