/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.base.topology;

import io.zeebe.broker.clustering.base.topology.NodeInfo;
import io.zeebe.broker.clustering.base.topology.TopologyPartitionListener;
import io.zeebe.util.sched.ActorControl;
import org.agrona.collections.Int2ObjectHashMap;

public class TopologyPartitionListenerImpl
implements TopologyPartitionListener {
    private final Int2ObjectHashMap<NodeInfo> partitionLeaders = new Int2ObjectHashMap();
    private final ActorControl actor;

    public TopologyPartitionListenerImpl(ActorControl actor) {
        this.actor = actor;
    }

    @Override
    public void onPartitionUpdated(int partitionId, NodeInfo member) {
        if (member.getLeaders().contains(partitionId)) {
            this.actor.submit(() -> this.updatePartitionLeader(partitionId, member));
        }
    }

    private void updatePartitionLeader(int partitionId, NodeInfo member) {
        NodeInfo currentLeader = (NodeInfo)this.partitionLeaders.get(partitionId);
        if (currentLeader == null || !currentLeader.equals(member)) {
            this.partitionLeaders.put(partitionId, (Object)member);
        }
    }

    public Int2ObjectHashMap<NodeInfo> getPartitionLeaders() {
        return this.partitionLeaders;
    }
}

