/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.engine;

import io.zeebe.broker.clustering.base.ClusterBaseLayerServiceNames;
import io.zeebe.broker.engine.EngineService;
import io.zeebe.broker.engine.EngineServiceNames;
import io.zeebe.broker.engine.impl.SubscriptionApiCommandMessageHandlerService;
import io.zeebe.broker.system.Component;
import io.zeebe.broker.system.SystemContext;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.transport.TransportServiceNames;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceContainer;

public class EngineComponent
implements Component {
    @Override
    public void init(SystemContext context) {
        ServiceContainer serviceContainer = context.getServiceContainer();
        BrokerCfg brokerConfiguration = context.getBrokerConfiguration();
        EngineService streamProcessorService = new EngineService(serviceContainer, brokerConfiguration);
        serviceContainer.createService(EngineServiceNames.ENGINE_SERVICE_NAME, (Service)streamProcessorService).dependency(TransportServiceNames.serverTransport("commandApi.server"), streamProcessorService.getCommandApiTransportInjector()).dependency(ClusterBaseLayerServiceNames.TOPOLOGY_MANAGER_SERVICE, streamProcessorService.getTopologyManagerInjector()).dependency(ClusterBaseLayerServiceNames.ATOMIX_SERVICE, streamProcessorService.getAtomixInjector()).groupReference(ClusterBaseLayerServiceNames.LEADER_PARTITION_GROUP_NAME, streamProcessorService.getPartitionsGroupReference()).install();
        SubscriptionApiCommandMessageHandlerService messageHandlerService = new SubscriptionApiCommandMessageHandlerService();
        serviceContainer.createService(EngineServiceNames.SUBSCRIPTION_API_MESSAGE_HANDLER_SERVICE_NAME, (Service)messageHandlerService).dependency(ClusterBaseLayerServiceNames.ATOMIX_SERVICE, messageHandlerService.getAtomixInjector()).groupReference(ClusterBaseLayerServiceNames.LEADER_PARTITION_GROUP_NAME, messageHandlerService.getLeaderParitionsGroupReference()).install();
    }
}

