/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.engine;

import io.atomix.core.Atomix;
import io.zeebe.broker.clustering.base.partitions.Partition;
import io.zeebe.broker.clustering.base.topology.TopologyManager;
import io.zeebe.broker.clustering.base.topology.TopologyPartitionListenerImpl;
import io.zeebe.broker.engine.impl.DeploymentDistributorImpl;
import io.zeebe.broker.engine.impl.PartitionCommandSenderImpl;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.ClusterCfg;
import io.zeebe.broker.system.configuration.DataCfg;
import io.zeebe.broker.transport.commandapi.CommandResponseWriterImpl;
import io.zeebe.engine.processor.AsyncSnapshotingDirectorService;
import io.zeebe.engine.processor.CommandResponseWriter;
import io.zeebe.engine.processor.ProcessingContext;
import io.zeebe.engine.processor.StreamProcessor;
import io.zeebe.engine.processor.StreamProcessorServiceNames;
import io.zeebe.engine.processor.TypedRecordProcessors;
import io.zeebe.engine.processor.workflow.EngineProcessors;
import io.zeebe.engine.processor.workflow.deployment.distribute.DeploymentDistributor;
import io.zeebe.engine.processor.workflow.message.command.PartitionCommandSender;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.servicecontainer.ServiceGroupReference;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.transport.ServerTransport;
import io.zeebe.util.DurationUtil;
import io.zeebe.util.sched.ActorControl;
import java.time.Duration;

public class EngineService
implements Service<EngineService> {
    public static final String PROCESSOR_NAME = "zb-stream-processor";
    private final Injector<ServerTransport> commandApiTransportInjector = new Injector();
    private final Injector<TopologyManager> topologyManagerInjector = new Injector();
    private final Injector<Atomix> atomixInjector = new Injector();
    private final ClusterCfg clusterCfg;
    private final ServiceContainer serviceContainer;
    private final Duration snapshotPeriod;
    private ServiceStartContext serviceContext;
    private ServerTransport commandApiTransport;
    private TopologyManager topologyManager;
    private Atomix atomix;
    private final ServiceGroupReference<Partition> partitionsGroupReference = ServiceGroupReference.create().onAdd(this::startEngineForPartition).build();

    public EngineService(ServiceContainer serviceContainer, BrokerCfg brokerCfg) {
        this.clusterCfg = brokerCfg.getCluster();
        this.serviceContainer = serviceContainer;
        DataCfg dataCfg = brokerCfg.getData();
        this.snapshotPeriod = DurationUtil.parse((String)dataCfg.getSnapshotPeriod());
    }

    public void start(ServiceStartContext serviceContext) {
        this.serviceContext = serviceContext;
        this.commandApiTransport = (ServerTransport)this.commandApiTransportInjector.getValue();
        this.topologyManager = (TopologyManager)this.topologyManagerInjector.getValue();
        this.atomix = (Atomix)this.atomixInjector.getValue();
    }

    public void startEngineForPartition(ServiceName<Partition> partitionServiceName, Partition partition) {
        int partitionId = partition.getPartitionId();
        LogStream logStream = partition.getLogStream();
        StreamProcessor.builder((int)partitionId, (String)PROCESSOR_NAME).logStream(logStream).actorScheduler(this.serviceContext.getScheduler()).additionalDependencies(partitionServiceName).zeebeDb(partition.getZeebeDb()).serviceContainer(this.serviceContainer).commandResponseWriter((CommandResponseWriter)new CommandResponseWriterImpl(this.commandApiTransport.getOutput())).streamProcessorFactory(processingContext -> {
            ActorControl actor = processingContext.getActor();
            ZeebeState zeebeState = processingContext.getZeebeState();
            return this.createTypedStreamProcessor(actor, zeebeState, processingContext);
        }).build();
        this.createAsyncSnapshotDirectorService(partition);
    }

    private void createAsyncSnapshotDirectorService(Partition partition) {
        String logName = partition.getLogStream().getLogName();
        AsyncSnapshotingDirectorService snapshotDirectorService = new AsyncSnapshotingDirectorService(partition.getPartitionId(), partition.getLogStream(), partition.getSnapshotController(), this.snapshotPeriod);
        ServiceName snapshotDirectorServiceName = StreamProcessorServiceNames.asyncSnapshotingDirectorService((String)logName, (String)PROCESSOR_NAME);
        ServiceName streamProcessorControllerServiceName = StreamProcessorServiceNames.streamProcessorService((String)logName, (String)PROCESSOR_NAME);
        this.serviceContext.createService(snapshotDirectorServiceName, (Service)snapshotDirectorService).dependency(streamProcessorControllerServiceName, snapshotDirectorService.getStreamProcessorInjector()).install();
    }

    public TypedRecordProcessors createTypedStreamProcessor(ActorControl actor, ZeebeState zeebeState, ProcessingContext processingContext) {
        LogStream stream = processingContext.getLogStream();
        TopologyPartitionListenerImpl partitionListener = new TopologyPartitionListenerImpl(actor);
        this.topologyManager.addTopologyPartitionListener(partitionListener);
        DeploymentDistributorImpl deploymentDistributor = new DeploymentDistributorImpl(this.clusterCfg, this.atomix, partitionListener, zeebeState.getDeploymentState(), actor);
        PartitionCommandSenderImpl partitionCommandSender = new PartitionCommandSenderImpl(this.atomix, this.topologyManager, actor);
        SubscriptionCommandSender subscriptionCommandSender = new SubscriptionCommandSender(stream.getPartitionId(), (PartitionCommandSender)partitionCommandSender);
        return EngineProcessors.createEngineProcessors((ProcessingContext)processingContext, (int)this.clusterCfg.getPartitionsCount(), (SubscriptionCommandSender)subscriptionCommandSender, (DeploymentDistributor)deploymentDistributor);
    }

    public EngineService get() {
        return this;
    }

    public Injector<ServerTransport> getCommandApiTransportInjector() {
        return this.commandApiTransportInjector;
    }

    public ServiceGroupReference<Partition> getPartitionsGroupReference() {
        return this.partitionsGroupReference;
    }

    public Injector<TopologyManager> getTopologyManagerInjector() {
        return this.topologyManagerInjector;
    }

    public Injector<Atomix> getAtomixInjector() {
        return this.atomixInjector;
    }
}

