/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.engine.impl;

import io.atomix.cluster.MemberId;
import io.atomix.core.Atomix;
import io.zeebe.broker.Loggers;
import io.zeebe.broker.clustering.base.topology.NodeInfo;
import io.zeebe.broker.clustering.base.topology.TopologyPartitionListenerImpl;
import io.zeebe.broker.system.configuration.ClusterCfg;
import io.zeebe.broker.system.management.deployment.NotLeaderResponse;
import io.zeebe.broker.system.management.deployment.PushDeploymentRequest;
import io.zeebe.broker.system.management.deployment.PushDeploymentResponse;
import io.zeebe.engine.processor.workflow.deployment.distribute.DeploymentDistributor;
import io.zeebe.engine.processor.workflow.deployment.distribute.PendingDeploymentDistribution;
import io.zeebe.engine.state.deployment.DeploymentsState;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.IntArrayList;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class DeploymentDistributorImpl
implements DeploymentDistributor {
    private static final Logger LOG = Loggers.WORKFLOW_REPOSITORY_LOGGER;
    public static final Duration PUSH_REQUEST_TIMEOUT = Duration.ofSeconds(15L);
    public static final Duration RETRY_DELAY = Duration.ofMillis(100L);
    private final PushDeploymentRequest pushDeploymentRequest = new PushDeploymentRequest();
    private final PushDeploymentResponse pushDeploymentResponse = new PushDeploymentResponse();
    private final NotLeaderResponse notLeaderResponse = new NotLeaderResponse();
    private final TopologyPartitionListenerImpl partitionListener;
    private final ActorControl actor;
    private final transient Long2ObjectHashMap<ActorFuture<Void>> pendingDeploymentFutures = new Long2ObjectHashMap();
    private final DeploymentsState deploymentsState;
    private final IntArrayList partitionsToDistributeTo;
    private final Atomix atomix;

    public DeploymentDistributorImpl(ClusterCfg clusterCfg, Atomix atomix, TopologyPartitionListenerImpl partitionListener, DeploymentsState deploymentsState, ActorControl actor) {
        this.atomix = atomix;
        this.partitionListener = partitionListener;
        this.actor = actor;
        this.deploymentsState = deploymentsState;
        this.partitionsToDistributeTo = this.partitionsToDistributeTo(clusterCfg);
    }

    private IntArrayList partitionsToDistributeTo(ClusterCfg clusterCfg) {
        IntArrayList list = new IntArrayList();
        list.addAll(clusterCfg.getPartitionIds());
        list.removeInt(1);
        return list;
    }

    public ActorFuture<Void> pushDeployment(long key, long position, DirectBuffer buffer) {
        CompletableActorFuture pushedFuture = new CompletableActorFuture();
        PendingDeploymentDistribution pendingDeploymentDistribution = new PendingDeploymentDistribution(buffer, position);
        this.deploymentsState.putPendingDeployment(key, pendingDeploymentDistribution);
        this.pendingDeploymentFutures.put(key, (Object)pushedFuture);
        this.pushDeploymentToPartitions(key);
        return pushedFuture;
    }

    public PendingDeploymentDistribution removePendingDeployment(long key) {
        return this.deploymentsState.removePendingDeployment(key);
    }

    private void pushDeploymentToPartitions(long key) {
        if (!this.partitionsToDistributeTo.isEmpty()) {
            this.deployOnMultiplePartitions(key);
        } else {
            LOG.trace("No other partitions to distribute deployment.");
            LOG.trace("Deployment finished.");
            ((ActorFuture)this.pendingDeploymentFutures.remove(key)).complete(null);
        }
    }

    private void deployOnMultiplePartitions(long key) {
        LOG.trace("Distribute deployment to other partitions.");
        PendingDeploymentDistribution pendingDeploymentDistribution = this.deploymentsState.getPendingDeployment(key);
        DirectBuffer directBuffer = pendingDeploymentDistribution.getDeployment();
        pendingDeploymentDistribution.setDistributionCount((long)this.partitionsToDistributeTo.size());
        this.pushDeploymentRequest.reset();
        this.pushDeploymentRequest.deployment(directBuffer).deploymentKey(key);
        IntArrayList modifiablePartitionsList = new IntArrayList();
        modifiablePartitionsList.addAll((Collection)this.partitionsToDistributeTo);
        this.distributeDeployment(modifiablePartitionsList);
    }

    private void distributeDeployment(IntArrayList partitionsToDistribute) {
        IntArrayList remainingPartitions = this.distributeDeploymentToPartitions(partitionsToDistribute);
        if (remainingPartitions.isEmpty()) {
            LOG.trace("Pushed deployment to all partitions");
            return;
        }
        this.actor.runDelayed(RETRY_DELAY, () -> this.distributeDeployment(remainingPartitions));
    }

    private IntArrayList distributeDeploymentToPartitions(IntArrayList remainingPartitions) {
        Int2ObjectHashMap<NodeInfo> currentPartitionLeaders = this.partitionListener.getPartitionLeaders();
        Iterator iterator = remainingPartitions.iterator();
        while (iterator.hasNext()) {
            Integer partitionId = (Integer)iterator.next();
            NodeInfo leader = (NodeInfo)currentPartitionLeaders.get((Object)partitionId);
            if (leader == null) continue;
            iterator.remove();
            this.pushDeploymentToPartition(leader.getNodeId(), partitionId);
        }
        return remainingPartitions;
    }

    private void pushDeploymentToPartition(int partitionLeaderId, int partition) {
        this.pushDeploymentRequest.partitionId(partition);
        byte[] bytes = this.pushDeploymentRequest.toBytes();
        MemberId memberId = new MemberId(Integer.toString(partitionLeaderId));
        CompletableFuture pushDeploymentFuture = this.atomix.getCommunicationService().send("deployment", (Object)bytes, memberId, PUSH_REQUEST_TIMEOUT);
        pushDeploymentFuture.whenComplete((response, throwable) -> this.actor.call(() -> {
            if (throwable == null) {
                this.handleResponse((byte[])response, partitionLeaderId, partition);
            } else {
                LOG.warn("Failed to push deployment to node {} for partition {}", new Object[]{partitionLeaderId, partition, throwable});
                this.handleRetry(partitionLeaderId, partition);
            }
        }));
    }

    private void handleResponse(byte[] response, int partitionLeaderId, int partition) {
        UnsafeBuffer responseBuffer = new UnsafeBuffer(response);
        if (this.pushDeploymentResponse.tryWrap((DirectBuffer)responseBuffer)) {
            this.pushDeploymentResponse.wrap((DirectBuffer)responseBuffer);
            this.handlePushResponse();
        } else if (this.notLeaderResponse.tryWrap((DirectBuffer)responseBuffer)) {
            LOG.warn("Node {} rejected deployment on partition {} as not leader", (Object)partitionLeaderId, (Object)partition);
            this.handleRetry(partitionLeaderId, partition);
        } else {
            LOG.warn("Received unknown deployment response from node {} for partition {}", (Object)partitionLeaderId, (Object)partition);
            this.handleRetry(partitionLeaderId, partition);
        }
    }

    private void handleRetry(int partitionLeaderId, int partition) {
        LOG.debug("Retry deployment to push to partition {} after {}ms", (Object)partition, (Object)RETRY_DELAY.toMillis());
        this.actor.runDelayed(RETRY_DELAY, () -> {
            Int2ObjectHashMap<NodeInfo> partitionLeaders = this.partitionListener.getPartitionLeaders();
            NodeInfo currentLeader = (NodeInfo)partitionLeaders.get(partition);
            if (currentLeader != null) {
                this.pushDeploymentToPartition(currentLeader.getNodeId(), partition);
            } else {
                this.pushDeploymentToPartition(partitionLeaderId, partition);
            }
        });
    }

    private void handlePushResponse() {
        long deploymentKey = this.pushDeploymentResponse.deploymentKey();
        PendingDeploymentDistribution pendingDeploymentDistribution = this.deploymentsState.getPendingDeployment(deploymentKey);
        long remainingPartitions = pendingDeploymentDistribution.decrementCount();
        if (remainingPartitions == 0L) {
            LOG.debug("Deployment pushed to all partitions successfully.");
            ((ActorFuture)this.pendingDeploymentFutures.remove(deploymentKey)).complete(null);
        } else {
            LOG.trace("Deployment was pushed to partition {} successfully.", (Object)this.pushDeploymentResponse.partitionId());
        }
    }
}

