/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.engine.impl;

import io.atomix.cluster.MemberId;
import io.atomix.core.Atomix;
import io.zeebe.broker.clustering.base.topology.NodeInfo;
import io.zeebe.broker.clustering.base.topology.TopologyManager;
import io.zeebe.broker.clustering.base.topology.TopologyPartitionListenerImpl;
import io.zeebe.engine.processor.workflow.message.command.PartitionCommandSender;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.sched.ActorControl;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;

public class PartitionCommandSenderImpl
implements PartitionCommandSender {
    private final Atomix atomix;
    private final TopologyPartitionListenerImpl partitionListener;

    public PartitionCommandSenderImpl(Atomix atomix, TopologyManager topologyManager, ActorControl actor) {
        this.atomix = atomix;
        this.partitionListener = new TopologyPartitionListenerImpl(actor);
        topologyManager.addTopologyPartitionListener(this.partitionListener);
    }

    public boolean sendCommand(int receiverPartitionId, BufferWriter command) {
        Int2ObjectHashMap<NodeInfo> partitionLeaders = this.partitionListener.getPartitionLeaders();
        NodeInfo partitionLeader = (NodeInfo)partitionLeaders.get(receiverPartitionId);
        if (partitionLeader == null) {
            return true;
        }
        byte[] bytes = new byte[command.getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        command.write((MutableDirectBuffer)buffer, 0);
        this.atomix.getCommunicationService().send("subscription", (Object)bytes, MemberId.from((String)("" + partitionLeader.getNodeId())));
        return true;
    }
}

