/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.engine.impl;

import io.zeebe.clustering.management.SnapshotChunkDecoder;
import io.zeebe.clustering.management.SnapshotChunkEncoder;
import io.zeebe.engine.util.SbeBufferWriterReader;
import io.zeebe.logstreams.state.SnapshotChunk;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class SnapshotChunkImpl
extends SbeBufferWriterReader<SnapshotChunkEncoder, SnapshotChunkDecoder>
implements SnapshotChunk {
    private final SnapshotChunkEncoder encoder = new SnapshotChunkEncoder();
    private final SnapshotChunkDecoder decoder = new SnapshotChunkDecoder();
    private long snapshotPosition;
    private int totalCount;
    private String chunkName;
    private long checksum;
    private final DirectBuffer content = new UnsafeBuffer(0L, 0);

    public SnapshotChunkImpl() {
    }

    public SnapshotChunkImpl(SnapshotChunk chunk) {
        this.snapshotPosition = chunk.getSnapshotPosition();
        this.totalCount = chunk.getTotalCount();
        this.chunkName = chunk.getChunkName();
        this.checksum = chunk.getChecksum();
        this.content.wrap(chunk.getContent());
    }

    public int getLength() {
        return super.getLength() + SnapshotChunkEncoder.chunkNameHeaderLength() + this.chunkName.length() + SnapshotChunkEncoder.contentHeaderLength() + this.content.capacity();
    }

    protected SnapshotChunkEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected SnapshotChunkDecoder getBodyDecoder() {
        return this.decoder;
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.snapshotPosition(this.snapshotPosition).totalCount(this.totalCount).chunkName(this.chunkName).checksum(this.checksum).putContent(this.content, 0, this.content.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.snapshotPosition = this.decoder.snapshotPosition();
        this.totalCount = this.decoder.totalCount();
        this.chunkName = this.decoder.chunkName();
        this.checksum = this.decoder.checksum();
        this.decoder.wrapContent(this.content);
    }

    public void reset() {
        super.reset();
        this.snapshotPosition = SnapshotChunkDecoder.snapshotPositionNullValue();
        this.totalCount = SnapshotChunkDecoder.totalCountNullValue();
        this.checksum = SnapshotChunkDecoder.checksumNullValue();
        this.chunkName = "";
        this.content.wrap(0L, 0);
    }

    public long getSnapshotPosition() {
        return this.snapshotPosition;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public String getChunkName() {
        return this.chunkName;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public byte[] getContent() {
        return BufferUtil.bufferAsArray((DirectBuffer)this.content);
    }
}

