/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.engine.impl;

import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.cluster.messaging.Subscription;
import io.zeebe.broker.engine.impl.SnapshotChunkImpl;
import io.zeebe.engine.Loggers;
import io.zeebe.logstreams.state.SnapshotChunk;
import io.zeebe.logstreams.state.SnapshotReplication;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class StateReplication
implements SnapshotReplication {
    public static final String REPLICATION_TOPIC_FORMAT = "replication-%d-%s";
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private final String replicationTopic;
    private final DirectBuffer readBuffer = new UnsafeBuffer(0L, 0);
    private final ClusterEventService eventService;
    private ExecutorService executorService;
    private Subscription subscription;

    public StateReplication(ClusterEventService eventService, int partitionId, String name) {
        this.eventService = eventService;
        this.replicationTopic = String.format(REPLICATION_TOPIC_FORMAT, partitionId, name);
    }

    public void replicate(SnapshotChunk snapshot) {
        this.eventService.broadcast(this.replicationTopic, (Object)snapshot, s -> {
            LOG.debug("Replicate on topic {} snapshot chunk {} for snapshot pos {}.", new Object[]{this.replicationTopic, s.getChunkName(), s.getSnapshotPosition()});
            SnapshotChunkImpl chunkImpl = new SnapshotChunkImpl((SnapshotChunk)s);
            return chunkImpl.toBytes();
        });
    }

    public void consume(Consumer<SnapshotChunk> consumer) {
        this.executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, this.replicationTopic));
        this.subscription = (Subscription)this.eventService.subscribe(this.replicationTopic, bytes -> {
            this.readBuffer.wrap(bytes);
            SnapshotChunkImpl chunk = new SnapshotChunkImpl();
            chunk.wrap(this.readBuffer, 0, ((byte[])bytes).length);
            LOG.debug("Received on topic {} replicated snapshot chunk {} for snapshot pos {}.", new Object[]{this.replicationTopic, chunk.getChunkName(), chunk.getSnapshotPosition()});
            return chunk;
        }, consumer, (Executor)this.executorService).join();
    }

    public void close() {
        if (this.subscription != null) {
            this.subscription.close().join();
            this.subscription = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }
}

