/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.engine.impl;

import io.atomix.core.Atomix;
import io.zeebe.broker.clustering.base.partitions.Partition;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandMessageHandler;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceGroupReference;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorControl;
import java.util.function.Function;
import org.agrona.collections.Int2ObjectHashMap;

public class SubscriptionApiCommandMessageHandlerService
extends Actor
implements Service<SubscriptionCommandMessageHandler> {
    private final Injector<Atomix> atomixInjector = new Injector();
    private final ServiceGroupReference<Partition> leaderPartitionsGroupReference = ServiceGroupReference.create().onAdd(this::addPartition).onRemove(this::removePartition).build();
    private final Int2ObjectHashMap<LogStream> leaderPartitions = new Int2ObjectHashMap();
    private SubscriptionCommandMessageHandler messageHandler;
    private Atomix atomix;

    public String getName() {
        return "subscription-api";
    }

    public void start(ServiceStartContext context) {
        this.atomix = (Atomix)this.atomixInjector.getValue();
        context.async(context.getScheduler().submitActor((Actor)this, true));
    }

    public void stop(ServiceStopContext stopContext) {
        stopContext.async(this.actor.close());
    }

    protected void onActorStarting() {
        this.messageHandler = new SubscriptionCommandMessageHandler(arg_0 -> ((ActorControl)this.actor).call(arg_0), arg_0 -> this.leaderPartitions.get(arg_0));
        this.atomix.getCommunicationService().subscribe("subscription", (Function)this.messageHandler);
    }

    private void addPartition(ServiceName<Partition> sericeName, Partition partition) {
        this.actor.submit(() -> {
            LogStream cfr_ignored_0 = (LogStream)this.leaderPartitions.put(partition.getPartitionId(), (Object)partition.getLogStream());
        });
    }

    private void removePartition(ServiceName<Partition> sericeName, Partition partition) {
        this.actor.submit(() -> {
            LogStream cfr_ignored_0 = (LogStream)this.leaderPartitions.remove(partition.getPartitionId());
        });
    }

    public SubscriptionCommandMessageHandler get() {
        return this.messageHandler;
    }

    public ServiceGroupReference<Partition> getLeaderParitionsGroupReference() {
        return this.leaderPartitionsGroupReference;
    }

    public Injector<Atomix> getAtomixInjector() {
        return this.atomixInjector;
    }
}

