/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.clustering.base.partitions.Partition;
import io.zeebe.broker.exporter.ExporterServiceNames;
import io.zeebe.broker.exporter.jar.ExporterJarLoadException;
import io.zeebe.broker.exporter.repo.ExporterLoadException;
import io.zeebe.broker.exporter.repo.ExporterRepository;
import io.zeebe.broker.exporter.stream.ExporterDirector;
import io.zeebe.broker.exporter.stream.ExporterDirectorContext;
import io.zeebe.broker.exporter.stream.ExportersState;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.DataCfg;
import io.zeebe.broker.system.configuration.ExporterCfg;
import io.zeebe.db.ZeebeDb;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.logstreams.impl.service.LogStreamServiceNames;
import io.zeebe.logstreams.log.BufferedLogStreamReader;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceGroupReference;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.util.DurationUtil;
import java.util.List;
import org.slf4j.Logger;

public class ExporterManagerService
implements Service<ExporterManagerService> {
    public static final int EXPORTER_PROCESSOR_ID = 1003;
    public static final String PROCESSOR_NAME = "exporter";
    private static final Logger LOG = Loggers.EXPORTER_LOGGER;
    private final ServiceGroupReference<Partition> partitionsGroupReference = ServiceGroupReference.create().onAdd(this::startExporter).build();
    private final List<ExporterCfg> exporterCfgs;
    private final ExporterRepository exporterRepository;
    private final DataCfg dataCfg;
    private ServiceStartContext startContext;
    private ExporterDirector director;

    public ExporterManagerService(BrokerCfg brokerCfg) {
        this.dataCfg = brokerCfg.getData();
        this.exporterCfgs = brokerCfg.getExporters();
        this.exporterRepository = new ExporterRepository();
    }

    public ExporterManagerService get() {
        return this;
    }

    public void start(ServiceStartContext startContext) {
        this.startContext = startContext;
        for (ExporterCfg exporterCfg : this.exporterCfgs) {
            try {
                this.exporterRepository.load(exporterCfg);
            }
            catch (ExporterJarLoadException | ExporterLoadException e) {
                throw new RuntimeException("Failed to load exporter with configuration: " + exporterCfg, e);
            }
        }
    }

    private void startExporter(ServiceName<Partition> partitionName, Partition partition) {
        ZeebeDb zeebeDb = partition.getZeebeDb();
        if (this.exporterRepository.getExporters().isEmpty()) {
            this.clearExporterState(partition.getZeebeDb());
        } else {
            ExporterDirectorContext context = new ExporterDirectorContext().id(1003).name(PROCESSOR_NAME).logStream(partition.getLogStream()).zeebeDb(zeebeDb).maxSnapshots(this.dataCfg.getMaxSnapshots()).descriptors(this.exporterRepository.getExporters().values()).logStreamReader((LogStreamReader)new BufferedLogStreamReader()).snapshotPeriod(DurationUtil.parse((String)this.dataCfg.getSnapshotPeriod()));
            LogStream logStream = partition.getLogStream();
            String logName = logStream.getLogName();
            this.director = new ExporterDirector(context);
            this.startContext.createService(ExporterServiceNames.exporterDirectorServiceName(partition.getPartitionId()), (Service)this.director).dependency(LogStreamServiceNames.logStreamServiceName((String)logName)).dependency(LogStreamServiceNames.logWriteBufferServiceName((String)logName)).dependency(LogStreamServiceNames.logStorageServiceName((String)logName)).dependency(LogStreamServiceNames.logBlockIndexServiceName((String)logName)).dependency(partitionName).install();
        }
    }

    public long getLowestExporterPosition() {
        if (this.exporterRepository.getExporters().isEmpty()) {
            return Long.MAX_VALUE;
        }
        return this.director.getLowestExporterPosition();
    }

    private void clearExporterState(ZeebeDb zeebeDb) {
        try {
            ExportersState state = new ExportersState((ZeebeDb<ZbColumnFamilies>)zeebeDb, zeebeDb.createContext());
            state.visitPositions((exporterId, position) -> {
                state.removePosition((String)exporterId);
                LOG.info("The exporter '{}' is not configured anymore. Its position is removed from the state.", exporterId);
            });
        }
        catch (Exception e) {
            LOG.error("Failed to remove exporters from state", (Throwable)e);
        }
    }

    public ServiceGroupReference<Partition> getPartitionsGroupReference() {
        return this.partitionsGroupReference;
    }
}

