/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class ExporterObjectMapper {
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final ObjectMapper msgpackObjectMapper;
    private final ObjectMapper jsonObjectMapper;

    public ExporterObjectMapper() {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(ExporterObjectMapper.class, (Object)this);
        this.msgpackObjectMapper = this.createMsgpackObjectMapper((InjectableValues)injectableValues);
        this.jsonObjectMapper = this.createDefaultObjectMapper((InjectableValues)injectableValues);
    }

    private ObjectMapper createDefaultObjectMapper(InjectableValues injectableValues) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setInjectableValues(injectableValues);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.enable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
        return objectMapper;
    }

    private ObjectMapper createMsgpackObjectMapper(InjectableValues injectableValues) {
        MessagePackFactory msgpackFactory = new MessagePackFactory().setReuseResourceInGenerator(false).setReuseResourceInParser(false);
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)msgpackFactory);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setInjectableValues(injectableValues);
        return objectMapper;
    }

    public String toJson(Object value) {
        try {
            return this.jsonObjectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(String.format("Failed to serialize object '%s' to JSON", value), e);
        }
    }

    public byte[] toMsgpack(Object value) {
        try {
            return this.msgpackObjectMapper.writeValueAsBytes(value);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to serialize object '%s' to Msgpack JSON", value), e);
        }
    }

    public Map<String, Object> fromJsonAsMap(String json) {
        try {
            return (Map)this.msgpackObjectMapper.readValue(json, MAP_TYPE_REFERENCE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed deserialize JSON to map", e);
        }
    }

    public Map<String, Object> fromMsgpackAsMap(InputStream inputStream) {
        try {
            return (Map)this.msgpackObjectMapper.readValue(inputStream, MAP_TYPE_REFERENCE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed deserialize Msgpack JSON to map", e);
        }
    }
}

