/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.context;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.zeebe.broker.exporter.ExporterException;
import io.zeebe.exporter.api.context.Configuration;
import java.util.Map;

public class ExporterConfiguration
implements Configuration {
    private static final Gson CONFIG_INSTANTIATOR = new GsonBuilder().create();
    private final String id;
    private final Map<String, Object> arguments;
    private JsonElement intermediateConfiguration;

    public ExporterConfiguration(String id, Map<String, Object> arguments) {
        this.id = id;
        this.arguments = arguments;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public <T> T instantiate(Class<T> configClass) {
        if (this.arguments != null) {
            return (T)CONFIG_INSTANTIATOR.fromJson(this.getIntermediateConfiguration(), configClass);
        }
        try {
            return configClass.newInstance();
        }
        catch (Exception e) {
            throw new ExporterException("Unable to instantiate config class " + configClass.getName() + " with default constructor", e);
        }
    }

    private JsonElement getIntermediateConfiguration() {
        if (this.intermediateConfiguration == null) {
            this.intermediateConfiguration = CONFIG_INSTANTIATOR.toJsonTree(this.arguments);
        }
        return this.intermediateConfiguration;
    }
}

