/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.debug;

import io.zeebe.broker.exporter.debug.DebugHttpServer;
import io.zeebe.broker.system.configuration.ExporterCfg;
import io.zeebe.exporter.api.Exporter;
import io.zeebe.exporter.api.context.Context;
import io.zeebe.protocol.record.Record;
import org.slf4j.Logger;

public class DebugHttpExporter
implements Exporter {
    private static DebugHttpServer httpServer;
    private Logger log;

    public void configure(Context context) {
        this.log = context.getLogger();
        this.initHttpServer(context);
    }

    private synchronized void initHttpServer(Context context) {
        if (httpServer == null) {
            DebugHttpExporterConfiguration configuration = (DebugHttpExporterConfiguration)context.getConfiguration().instantiate(DebugHttpExporterConfiguration.class);
            httpServer = new DebugHttpServer(configuration.port, configuration.limit);
            this.log.info("Debug http server started, inspect the last {} records on http://localhost:{}", (Object)configuration.limit, (Object)configuration.port);
        }
    }

    public void export(Record record) {
        try {
            httpServer.add(record);
        }
        catch (Exception e) {
            this.log.warn("Failed to serialize record {} to json", (Object)record, (Object)e);
        }
    }

    public void close() {
        this.stopHttpServer();
    }

    public synchronized void stopHttpServer() {
        if (httpServer != null) {
            httpServer.close();
            httpServer = null;
        }
    }

    public static ExporterCfg defaultConfig() {
        ExporterCfg exporterCfg = new ExporterCfg();
        exporterCfg.setId("http");
        exporterCfg.setClassName(DebugHttpExporter.class.getName());
        return exporterCfg;
    }

    public static class DebugHttpExporterConfiguration {
        public int port = 8000;
        public int limit = 1024;
    }
}

