/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.debug;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Charsets;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.zeebe.protocol.record.Record;
import io.zeebe.util.StreamUtil;
import io.zeebe.util.collection.Tuple;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;

public class DebugHttpServer {
    private static final Charset CHARSET = Charsets.UTF_8;
    private static final String[] RESOURCE_NAMES = new String[]{"index.html", "bootstrap-4.1.3.min.css", "bootstrap-4.1.3.min.js", "jquery-3.3.1.slim.min.js", "mustache-3.0.0.min.js"};
    private static final Map<String, String> CONTENT_TYPES = new HashMap<String, String>();
    private final int maxSize;
    private HttpServer server;
    private final Map<String, byte[]> resources;
    private ObjectMapper objectMapper;
    private final LinkedList<String> records;

    public DebugHttpServer(int port, int maxSize) {
        this.maxSize = maxSize;
        this.server = this.startHttpServer(port);
        this.resources = this.loadResources();
        this.objectMapper = this.createObjectMapper();
        this.records = new LinkedList();
    }

    public void close() {
        if (this.server != null) {
            this.server.stop(0);
            this.server = null;
        }
    }

    private HttpServer startHttpServer(int port) {
        try {
            HttpServer httpServer = HttpServer.create(new InetSocketAddress(port), 0);
            httpServer.createContext("/", new RequestHandler());
            httpServer.start();
            return this.server;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to start debug exporter http server", e);
        }
    }

    private Map<String, byte[]> loadResources() {
        return Arrays.stream(RESOURCE_NAMES).map(resourceName -> new Tuple(resourceName, (Object)this.loadResource((String)resourceName))).collect(Collectors.toConcurrentMap(Tuple::getLeft, Tuple::getRight));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadResource(String resourceName) {
        try (InputStream resourceAsStream = DebugHttpServer.class.getResourceAsStream(resourceName);){
            if (resourceAsStream != null) {
                byte[] byArray = StreamUtil.read((InputStream)resourceAsStream);
                return byArray;
            }
            throw new RuntimeException("Failed to find resource " + resourceName + " for debug http exporter");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read resource " + resourceName + " for debug http exporter", e);
        }
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return objectMapper;
    }

    public synchronized void add(Record record) throws JsonProcessingException {
        while (this.records.size() >= this.maxSize) {
            this.records.removeLast();
        }
        this.records.addFirst(this.objectMapper.writeValueAsString((Object)record));
    }

    static {
        CONTENT_TYPES.put(".css", "text/css");
        CONTENT_TYPES.put(".html", "text/html");
        CONTENT_TYPES.put(".js", "text/javascript");
        CONTENT_TYPES.put(".json", "application/json");
    }

    class RequestHandler
    implements HttpHandler {
        RequestHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            byte[] response;
            String path = httpExchange.getRequestURI().getPath().substring(1);
            if (path.isEmpty()) {
                path = "index.html";
            }
            String extension = path.substring(path.lastIndexOf(46));
            String contentType = (String)CONTENT_TYPES.get(extension);
            if (contentType != null) {
                httpExchange.getResponseHeaders().add("Content-Type", contentType);
            }
            if ((response = "records.json".equals(path) ? this.getRecords() : (byte[])DebugHttpServer.this.resources.get(path)).length > 0) {
                httpExchange.sendResponseHeaders(200, response.length);
                try (OutputStream outputStream = httpExchange.getResponseBody();){
                    outputStream.write(response);
                }
            } else {
                httpExchange.sendResponseHeaders(404, 0L);
            }
        }

        private byte[] getRecords() {
            String json = "[" + String.join((CharSequence)",", DebugHttpServer.this.records) + "]";
            return json.getBytes(CHARSET);
        }
    }
}

