/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.debug;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.zeebe.broker.system.configuration.ExporterCfg;
import io.zeebe.exporter.api.Exporter;
import io.zeebe.exporter.api.context.Context;
import io.zeebe.exporter.api.context.Controller;
import io.zeebe.protocol.record.Record;
import java.util.Collections;
import org.slf4j.Logger;

public class DebugLogExporter
implements Exporter {
    private Logger log;
    private LogLevel logLevel;
    private DebugExporterConfiguration configuration;
    private ObjectMapper objectMapper;

    public void configure(Context context) {
        this.log = context.getLogger();
        this.configuration = (DebugExporterConfiguration)context.getConfiguration().instantiate(DebugExporterConfiguration.class);
        this.logLevel = this.configuration.getLogLevel();
    }

    public void open(Controller controller) {
        this.log("Debug exporter opened", new Object[0]);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        if (this.configuration.prettyPrint) {
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    public void close() {
        this.log("Debug exporter closed", new Object[0]);
    }

    public void export(Record record) {
        try {
            this.log("{}", this.objectMapper.writeValueAsString((Object)record));
        }
        catch (JsonProcessingException e) {
            this.log("Failed to serialize object '{}' to JSON", new Object[]{record, e});
        }
    }

    public static ExporterCfg defaultConfig(boolean prettyPrint) {
        ExporterCfg exporterCfg = new ExporterCfg();
        exporterCfg.setId("debug");
        exporterCfg.setClassName(DebugLogExporter.class.getName());
        exporterCfg.setArgs(Collections.singletonMap("prettyPrint", prettyPrint));
        return exporterCfg;
    }

    public void log(String message, Object ... args) {
        switch (this.logLevel) {
            case TRACE: {
                this.log.trace(message, args);
                break;
            }
            case DEBUG: {
                this.log.debug(message, args);
                break;
            }
            case INFO: {
                this.log.info(message, args);
                break;
            }
            case WARN: {
                this.log.warn(message, args);
                break;
            }
            case ERROR: {
                this.log.error(message, args);
            }
        }
    }

    static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }

    public static class DebugExporterConfiguration {
        public String logLevel = "debug";
        public boolean prettyPrint = false;

        LogLevel getLogLevel() {
            return LogLevel.valueOf(this.logLevel.trim().toUpperCase());
        }
    }
}

