/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.jar;

import io.zeebe.broker.exporter.jar.ExporterJarLoadException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;

public class ExporterJarClassLoader
extends URLClassLoader {
    public static final String JAVA_PACKAGE_PREFIX = "java.";
    public static final String JAR_URL_FORMAT = "jar:%s!/";
    public static final String[] EXPOSED_PACKAGE_PREFIXES = new String[]{"io.zeebe.exporter.api", "org.slf4j.", "org.apache.logging.log4j."};

    public ExporterJarClassLoader(URL[] urls) {
        super(urls);
    }

    public static ExporterJarClassLoader ofPath(Path jarPath) throws ExporterJarLoadException {
        URL jarUrl;
        try {
            String expandedPath = jarPath.toUri().toURL().toString();
            jarUrl = new URL(String.format(JAR_URL_FORMAT, expandedPath));
        }
        catch (MalformedURLException e) {
            throw new ExporterJarLoadException(jarPath, "bad JAR url", e);
        }
        return new ExporterJarClassLoader(new URL[]{jarUrl});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            if (name.startsWith(JAVA_PACKAGE_PREFIX)) {
                return this.findSystemClass(name);
            }
            if (this.isProvidedByBroker(name)) {
                return ExporterJarClassLoader.getSystemClassLoader().loadClass(name);
            }
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                try {
                    clazz = this.findClass(name);
                }
                catch (ClassNotFoundException ex) {
                    clazz = super.loadClass(name);
                }
            }
            return clazz;
        }
    }

    private boolean isProvidedByBroker(String name) {
        for (String prefix : EXPOSED_PACKAGE_PREFIXES) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

