/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.record;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.zeebe.broker.exporter.ExporterObjectMapper;
import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.RecordMetadata;
import io.zeebe.protocol.record.RecordValue;
import java.time.Instant;
import java.util.function.Supplier;

public class RecordImpl<T extends RecordValue>
implements Record<T> {
    private final long key;
    private final long position;
    private final Instant timestamp;
    private final int producerId;
    private final long sourceRecordPosition;
    private final RecordMetadata metadata;
    @JsonIgnore
    private final Supplier<T> valueSupplier;
    @JsonIgnore
    private T value = null;
    @JsonIgnore
    private final ExporterObjectMapper objectMapper;

    public RecordImpl(ExporterObjectMapper objectMapper, long key, long position, Instant timestamp, int producerId, long sourceRecordPosition, RecordMetadata metadata, Supplier<T> valueSupplier) {
        this.objectMapper = objectMapper;
        this.key = key;
        this.position = position;
        this.timestamp = timestamp;
        this.producerId = producerId;
        this.sourceRecordPosition = sourceRecordPosition;
        this.metadata = metadata;
        this.valueSupplier = valueSupplier;
    }

    public long getKey() {
        return this.key;
    }

    public long getPosition() {
        return this.position;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public int getProducerId() {
        return this.producerId;
    }

    public long getSourceRecordPosition() {
        return this.sourceRecordPosition;
    }

    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty
    public T getValue() {
        if (this.value == null) {
            this.value = (RecordValue)this.valueSupplier.get();
        }
        return this.value;
    }

    public ExporterObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String toJson() {
        return this.objectMapper.toJson(this);
    }

    public String toString() {
        return "RecordImpl{key=" + this.key + ", position=" + this.position + ", timestamp=" + this.timestamp + ", producerId=" + this.producerId + ", sourceRecordPosition=" + this.sourceRecordPosition + ", metadata=" + this.metadata + ", value=" + this.getValue() + '}';
    }
}

