/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.record;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.zeebe.broker.exporter.ExporterObjectMapper;
import io.zeebe.protocol.record.RecordMetadata;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RecordMetadataImpl
implements RecordMetadata {
    private final ExporterObjectMapper objectMapper;
    private final ValueType valueType;
    private final Intent intent;
    private final RecordType recordType;
    private final int partitionId;
    private final RejectionType rejectionType;
    private final String rejectionReason;

    public RecordMetadataImpl(ExporterObjectMapper objectMapper, int partitionId, Intent intent, RecordType recordType, RejectionType rejectionType, String rejectionReason, ValueType valueType) {
        this.objectMapper = objectMapper;
        this.partitionId = partitionId;
        this.intent = intent;
        this.recordType = recordType;
        this.rejectionType = rejectionType;
        this.rejectionReason = rejectionReason;
        this.valueType = valueType;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public RecordType getRecordType() {
        return this.recordType;
    }

    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public String toJson() {
        return this.objectMapper.toJson(this);
    }

    public String toString() {
        return "RecordMetadataImpl{partitionId=" + this.partitionId + ", intent=" + this.intent + ", recordType=" + this.recordType + ", rejectionType=" + this.rejectionType + ", rejectionReason='" + this.rejectionReason + '\'' + ", valueType=" + this.valueType + '}';
    }
}

