/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.record;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.zeebe.broker.exporter.ExporterObjectMapper;
import io.zeebe.broker.exporter.record.RecordValueImpl;
import io.zeebe.protocol.record.RecordValueWithVariables;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class RecordValueWithVariablesImpl
extends RecordValueImpl
implements RecordValueWithVariables {
    @JsonIgnore
    private final Supplier<String> variablesSupplier;
    @JsonIgnore
    private final Supplier<Map<String, Object>> variableMapSupplier;
    @JsonIgnore
    private String variables = null;
    @JsonIgnore
    private Map<String, Object> variableMap = null;

    public RecordValueWithVariablesImpl(ExporterObjectMapper objectMapper, Supplier<String> variablesSupplier, Supplier<Map<String, Object>> variableMapSupplier) {
        super(objectMapper);
        this.variablesSupplier = variablesSupplier;
        this.variableMapSupplier = variableMapSupplier;
    }

    @JsonProperty
    public String getVariables() {
        if (this.variables == null) {
            this.variables = this.variablesSupplier.get();
        }
        return this.variables;
    }

    @JsonIgnore
    public Map<String, Object> getVariablesAsMap() {
        if (this.variableMap == null) {
            this.variableMap = this.variableMapSupplier.get();
        }
        return this.variableMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordValueWithVariablesImpl that = (RecordValueWithVariablesImpl)o;
        return Objects.equals(this.variables, that.variables);
    }

    public int hashCode() {
        return Objects.hash(this.variables);
    }
}

