/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.record.value;

import io.zeebe.broker.exporter.ExporterObjectMapper;
import io.zeebe.broker.exporter.record.RecordValueImpl;
import io.zeebe.protocol.record.value.JobBatchRecordValue;
import io.zeebe.protocol.record.value.JobRecordValue;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

public class JobBatchRecordValueImpl
extends RecordValueImpl
implements JobBatchRecordValue {
    private final String type;
    private final String worker;
    private final Duration timeout;
    private final int maxJobsToActivate;
    private final List<Long> jobKeys;
    private final List<JobRecordValue> jobs;
    private final boolean truncated;

    public JobBatchRecordValueImpl(ExporterObjectMapper objectMapper, String type, String worker, Duration timeout, int maxJobsToActivate, List<Long> jobKeys, List<JobRecordValue> jobs, boolean truncated) {
        super(objectMapper);
        this.type = type;
        this.worker = worker;
        this.timeout = timeout;
        this.maxJobsToActivate = maxJobsToActivate;
        this.jobKeys = jobKeys;
        this.jobs = jobs;
        this.truncated = truncated;
    }

    public String getType() {
        return this.type;
    }

    public String getWorker() {
        return this.worker;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public int getMaxJobsToActivate() {
        return this.maxJobsToActivate;
    }

    public List<Long> getJobKeys() {
        return this.jobKeys;
    }

    public List<JobRecordValue> getJobs() {
        return this.jobs;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobBatchRecordValueImpl that = (JobBatchRecordValueImpl)o;
        return this.maxJobsToActivate == that.maxJobsToActivate && Objects.equals(this.type, that.type) && Objects.equals(this.worker, that.worker) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.jobKeys, that.jobKeys) && Objects.equals(this.jobs, that.jobs) && this.truncated == that.truncated;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.worker, this.timeout, this.maxJobsToActivate, this.jobKeys, this.jobs, this.truncated);
    }

    public String toString() {
        return "JobBatchRecordValueImpl{type='" + this.type + '\'' + ", truncated=" + this.truncated + ", worker='" + this.worker + '\'' + ", timeout=" + this.timeout + ", maxJobsToActivate=" + this.maxJobsToActivate + ", jobKeys=" + this.jobKeys + ", jobs=" + this.jobs + '}';
    }
}

