/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.record.value;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.zeebe.broker.exporter.ExporterObjectMapper;
import io.zeebe.broker.exporter.record.RecordValueWithVariablesImpl;
import io.zeebe.broker.exporter.record.value.job.HeadersImpl;
import io.zeebe.protocol.record.value.JobRecordValue;
import io.zeebe.protocol.record.value.job.Headers;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class JobRecordValueImpl
extends RecordValueWithVariablesImpl
implements JobRecordValue {
    private final String type;
    private final String worker;
    private final Instant deadline;
    private final HeadersImpl headers;
    private final int retries;
    private final String errorMessage;
    @JsonIgnore
    private final Supplier<Map<String, Object>> customHeaderSupplier;
    @JsonIgnore
    private Map<String, Object> customHeaders;

    public JobRecordValueImpl(ExporterObjectMapper objectMapper, Supplier<String> variablesSupplier, Supplier<Map<String, Object>> variableMapSupplier, String type, String worker, Instant deadline, HeadersImpl headers, Supplier<Map<String, Object>> customHeaderSupplier, int retries, String errorMessage) {
        super(objectMapper, variablesSupplier, variableMapSupplier);
        this.type = type;
        this.worker = worker;
        this.deadline = deadline;
        this.headers = headers;
        this.customHeaderSupplier = customHeaderSupplier;
        this.retries = retries;
        this.errorMessage = errorMessage;
    }

    public String getType() {
        return this.type;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    @JsonProperty
    public Map<String, Object> getCustomHeaders() {
        if (this.customHeaders == null) {
            this.customHeaders = this.customHeaderSupplier.get();
        }
        return this.customHeaders;
    }

    public String getWorker() {
        return this.worker;
    }

    public int getRetries() {
        return this.retries;
    }

    public Instant getDeadline() {
        return this.deadline;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobRecordValueImpl that = (JobRecordValueImpl)o;
        return this.retries == that.retries && Objects.equals(this.type, that.type) && Objects.equals(this.worker, that.worker) && Objects.equals(this.deadline, that.deadline) && Objects.equals(this.headers, that.headers) && Objects.equals(this.customHeaders, that.customHeaders) && Objects.equals(this.errorMessage, that.errorMessage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.type, this.worker, this.deadline, this.headers, this.customHeaders, this.retries, this.errorMessage);
    }

    public String toString() {
        return "JobRecordValueImpl{type='" + this.type + '\'' + ", worker='" + this.worker + '\'' + ", deadline=" + this.deadline + ", headers=" + this.headers + ", customHeaders=" + this.getCustomHeaders() + ", retries=" + this.retries + ", errorMessage='" + this.errorMessage + '\'' + ", variables='" + this.getVariables() + '\'' + '}';
    }
}

