/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.record.value;

import io.zeebe.broker.exporter.ExporterObjectMapper;
import io.zeebe.broker.exporter.record.RecordValueWithVariablesImpl;
import io.zeebe.protocol.record.value.MessageRecordValue;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class MessageRecordValueImpl
extends RecordValueWithVariablesImpl
implements MessageRecordValue {
    private final String name;
    private final String messageId;
    private final String correlationKey;
    private final long timeToLive;

    public MessageRecordValueImpl(ExporterObjectMapper objectMapper, Supplier<String> variablesSupplier, Supplier<Map<String, Object>> variableMapSupplier, String name, String messageId, String correlationKey, long timeToLive) {
        super(objectMapper, variablesSupplier, variableMapSupplier);
        this.name = name;
        this.messageId = messageId;
        this.correlationKey = correlationKey;
        this.timeToLive = timeToLive;
    }

    public String getName() {
        return this.name;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getCorrelationKey() {
        return this.correlationKey;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MessageRecordValueImpl that = (MessageRecordValueImpl)o;
        return this.timeToLive == that.timeToLive && Objects.equals(this.name, that.name) && Objects.equals(this.messageId, that.messageId) && Objects.equals(this.correlationKey, that.correlationKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.messageId, this.correlationKey, this.timeToLive);
    }

    public String toString() {
        return "MessageRecordValueImpl{name='" + this.name + '\'' + ", messageId='" + this.messageId + '\'' + ", correlationKey='" + this.correlationKey + '\'' + ", timeToLive=" + this.timeToLive + ", variables='" + this.getVariables() + '\'' + '}';
    }
}

