/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.record.value;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.zeebe.broker.exporter.ExporterObjectMapper;
import io.zeebe.broker.exporter.record.RecordValueImpl;
import io.zeebe.protocol.record.value.VariableRecordValue;
import java.util.Objects;
import java.util.function.Supplier;

public class VariableRecordValueImpl
extends RecordValueImpl
implements VariableRecordValue {
    private final String name;
    private final long scopeKey;
    private final long workflowInstanceKey;
    private final long workflowKey;
    @JsonIgnore
    private final Supplier<String> valueSupplier;
    @JsonIgnore
    private String value;

    public VariableRecordValueImpl(ExporterObjectMapper objectMapper, String name, Supplier<String> valueSupplier, long variableScopeKey, long workflowInstanceKey, long workflowKey) {
        super(objectMapper);
        this.name = name;
        this.valueSupplier = valueSupplier;
        this.scopeKey = variableScopeKey;
        this.workflowInstanceKey = workflowInstanceKey;
        this.workflowKey = workflowKey;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getValue() {
        if (this.value == null) {
            this.value = this.valueSupplier.get();
        }
        return this.value;
    }

    public long getScopeKey() {
        return this.scopeKey;
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKey;
    }

    public long getWorkflowKey() {
        return this.workflowKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableRecordValueImpl that = (VariableRecordValueImpl)o;
        return this.scopeKey == that.scopeKey && this.workflowInstanceKey == that.workflowInstanceKey && this.workflowKey == that.workflowKey && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.scopeKey, this.workflowInstanceKey, this.workflowKey);
    }

    public String toString() {
        return "VariableRecordValueImpl{name='" + this.name + '\'' + ", value='" + this.getValue() + '\'' + ", scopeKey=" + this.scopeKey + ", workflowInstanceKey=" + this.workflowInstanceKey + ", workflowKey=" + this.workflowKey + '}';
    }
}

