/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.record.value;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.zeebe.broker.exporter.ExporterObjectMapper;
import io.zeebe.broker.exporter.record.RecordValueImpl;
import io.zeebe.protocol.record.value.WorkflowInstanceCreationRecordValue;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class WorkflowInstanceCreationRecordValueImpl
extends RecordValueImpl
implements WorkflowInstanceCreationRecordValue {
    private final String bpmnProcessId;
    private final int version;
    private final long key;
    private final long instanceKey;
    @JsonIgnore
    private final Supplier<Map<String, Object>> variablesSupplier;
    @JsonIgnore
    private Map<String, Object> variables;

    public WorkflowInstanceCreationRecordValueImpl(ExporterObjectMapper objectMapper, String bpmnProcessId, int version, long key, long instanceKey, Supplier<Map<String, Object>> variablesSupplier) {
        super(objectMapper);
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.key = key;
        this.instanceKey = instanceKey;
        this.variablesSupplier = variablesSupplier;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public int getVersion() {
        return this.version;
    }

    public long getKey() {
        return this.key;
    }

    public long getInstanceKey() {
        return this.instanceKey;
    }

    @JsonProperty
    public Map<String, Object> getVariables() {
        if (this.variables == null) {
            this.variables = this.variablesSupplier.get();
        }
        return this.variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkflowInstanceCreationRecordValueImpl)) {
            return false;
        }
        WorkflowInstanceCreationRecordValueImpl that = (WorkflowInstanceCreationRecordValueImpl)o;
        return this.getVersion() == that.getVersion() && this.getKey() == that.getKey() && this.getInstanceKey() == that.getInstanceKey() && Objects.equals(this.getBpmnProcessId(), that.getBpmnProcessId()) && Objects.equals(this.getVariables(), that.getVariables());
    }

    public int hashCode() {
        return Objects.hash(this.getBpmnProcessId(), this.getVersion(), this.getKey(), this.getInstanceKey(), this.getVariables());
    }

    public String toString() {
        return "WorkflowInstanceCreationRecordValueImpl{bpmnProcessId='" + this.bpmnProcessId + '\'' + ", version=" + this.version + ", key=" + this.key + ", workflowInstanceKey=" + this.instanceKey + ", variables=" + this.getVariables() + "}";
    }
}

