/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.repo;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.exporter.context.ExporterContext;
import io.zeebe.broker.exporter.jar.ExporterJarLoadException;
import io.zeebe.broker.exporter.jar.ExporterJarRepository;
import io.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.zeebe.broker.exporter.repo.ExporterLoadException;
import io.zeebe.broker.system.configuration.ExporterCfg;
import io.zeebe.exporter.api.Exporter;
import io.zeebe.exporter.api.context.Context;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class ExporterRepository {
    private static final Logger LOG = Loggers.EXPORTER_LOGGER;
    private final ExporterJarRepository jarRepository;
    private final Map<String, ExporterDescriptor> exporters;

    public ExporterRepository() {
        this(new HashMap<String, ExporterDescriptor>(), new ExporterJarRepository());
    }

    public ExporterRepository(Map<String, ExporterDescriptor> exporters, ExporterJarRepository jarRepository) {
        this.exporters = exporters;
        this.jarRepository = jarRepository;
    }

    public Map<String, ExporterDescriptor> getExporters() {
        return Collections.unmodifiableMap(this.exporters);
    }

    public ExporterDescriptor load(String id, Class<? extends Exporter> exporterClass) throws ExporterLoadException {
        return this.load(id, exporterClass, null);
    }

    public ExporterDescriptor load(String id, Class<? extends Exporter> exporterClass, Map<String, Object> args) throws ExporterLoadException {
        ExporterDescriptor descriptor = this.exporters.get(id);
        if (descriptor == null) {
            descriptor = new ExporterDescriptor(id, exporterClass, args);
            this.validate(descriptor);
            this.exporters.put(id, descriptor);
        }
        return descriptor;
    }

    public ExporterDescriptor load(ExporterCfg config) throws ExporterLoadException, ExporterJarLoadException {
        Class<Exporter> exporterClass;
        String id = config.getId();
        if (this.exporters.containsKey(id)) {
            return this.exporters.get(id);
        }
        ClassLoader classLoader = !config.isExternal() ? this.getClass().getClassLoader() : this.jarRepository.load(config.getJarPath());
        try {
            Class<?> specifiedClass = classLoader.loadClass(config.getClassName());
            exporterClass = specifiedClass.asSubclass(Exporter.class);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new ExporterLoadException(id, "cannot load specified class", e);
        }
        return this.load(id, exporterClass, config.getArgs());
    }

    private void validate(ExporterDescriptor descriptor) throws ExporterLoadException {
        try {
            Exporter instance = descriptor.newInstance();
            ExporterContext context = new ExporterContext(LOG, descriptor.getConfiguration());
            instance.configure((Context)context);
        }
        catch (Exception ex) {
            throw new ExporterLoadException(descriptor.getId(), "failed validation", ex);
        }
    }
}

