/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.stream;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.exporter.ExporterObjectMapper;
import io.zeebe.broker.exporter.context.ExporterContext;
import io.zeebe.broker.exporter.record.RecordMetadataImpl;
import io.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.zeebe.broker.exporter.stream.ExporterDirectorContext;
import io.zeebe.broker.exporter.stream.ExporterMetrics;
import io.zeebe.broker.exporter.stream.ExporterRecordMapper;
import io.zeebe.broker.exporter.stream.ExportersState;
import io.zeebe.db.ZeebeDb;
import io.zeebe.engine.processor.AsyncSnapshotDirector;
import io.zeebe.engine.processor.EventFilter;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.exporter.api.Exporter;
import io.zeebe.exporter.api.context.Context;
import io.zeebe.exporter.api.context.Controller;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.LangUtil;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferUtil;
import io.zeebe.util.metrics.MetricsManager;
import io.zeebe.util.retry.AbortableRetryStrategy;
import io.zeebe.util.retry.EndlessRetryStrategy;
import io.zeebe.util.retry.RetryStrategy;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorCondition;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.SchedulingHints;
import io.zeebe.util.sched.future.ActorFuture;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.slf4j.Logger;

public class ExporterDirector
extends Actor
implements Service<ExporterDirector> {
    private static final String ERROR_MESSAGE_EXPORTING_ABORTED = "Expected to export record '{}' successfully, but exception was thrown.";
    private static final String ERROR_MESSAGE_RECOVER_FROM_SNAPSHOT_FAILED = "Expected to find event with the snapshot position %s in log stream, but nothing was found. Failed to recover '%s'.";
    private static final Logger LOG = Loggers.EXPORTER_LOGGER;
    private static final long NO_LAST_WRITTEN_EVENT_POSITION = -1L;
    private static final Consumer<Long> NO_DATA_REMOVER = pos -> {};
    private ActorScheduler actorScheduler;
    private final AtomicBoolean isOpened = new AtomicBoolean(false);
    private final List<ExporterContainer> containers;
    private final int partitionId;
    private final RecordMetadata rawMetadata;
    private final LogStream logStream;
    private final LogStreamReader logStreamReader;
    private final RecordExporter recordExporter = new RecordExporter();
    private final ZeebeDb zeebeDb;
    private final String name;
    private final ExporterDirectorContext context;
    private final RetryStrategy exportingRetryStrategy;
    private final RetryStrategy recordWrapStrategy;
    private EventFilter eventFilter;
    private ExportersState state;
    private ExporterMetrics metrics;
    private AsyncSnapshotDirector asyncSnapshotDirector;
    private ActorCondition onCommitPositionUpdatedCondition;
    private long lastExportedPosition;
    private boolean inExportingPhase;

    public ExporterDirector(ExporterDirectorContext context) {
        this.name = context.getName();
        this.context = context;
        this.containers = context.getDescriptors().stream().map(x$0 -> new ExporterContainer((ExporterDescriptor)x$0)).collect(Collectors.toList());
        this.logStream = context.getLogStream();
        this.partitionId = this.logStream.getPartitionId();
        this.rawMetadata = new RecordMetadata();
        this.logStreamReader = context.getLogStreamReader();
        this.exportingRetryStrategy = new AbortableRetryStrategy(this.actor);
        this.recordWrapStrategy = new EndlessRetryStrategy(this.actor);
        this.zeebeDb = context.getZeebeDb();
    }

    public void start(ServiceStartContext startContext) {
        this.actorScheduler = startContext.getScheduler();
        startContext.async(this.actorScheduler.submitActor((Actor)this, false, SchedulingHints.ioBound()));
    }

    public void stop(ServiceStopContext stopContext) {
        stopContext.async(this.actor.close());
    }

    public String getName() {
        return this.name;
    }

    public ExporterDirector get() {
        return this;
    }

    protected void onActorStarting() {
        MetricsManager metricsManager = this.actorScheduler.getMetricsManager();
        this.metrics = new ExporterMetrics(metricsManager, this.getName(), Integer.toString(this.partitionId));
        this.logStreamReader.wrap(this.logStream);
    }

    protected void onActorStarted() {
        try {
            LOG.info("Recovering exporter '{}' from snapshot", (Object)this.getName());
            this.recoverFromSnapshot();
            for (ExporterContainer container : this.containers) {
                container.exporter.configure((Context)container.context);
            }
            this.eventFilter = this.createEventFilter(this.containers);
            LOG.info("Set event filter for exporters: {}", (Object)this.eventFilter);
        }
        catch (Throwable e) {
            this.onFailure();
            LangUtil.rethrowUnchecked((Throwable)e);
        }
        this.isOpened.set(true);
        this.onSnapshotRecovered();
    }

    private void recoverFromSnapshot() {
        boolean failedToRecoverReader;
        this.state = new ExportersState((ZeebeDb<ZbColumnFamilies>)this.zeebeDb, this.zeebeDb.createContext());
        long snapshotPosition = this.getLowestExporterPosition();
        boolean bl = failedToRecoverReader = !this.logStreamReader.seekToNextEvent(snapshotPosition);
        if (failedToRecoverReader) {
            throw new IllegalStateException(String.format(ERROR_MESSAGE_RECOVER_FROM_SNAPSHOT_FAILED, snapshotPosition, this.getName()));
        }
        LOG.info("Recovered exporter '{}' from snapshot at lastExportedPosition {}", (Object)this.getName(), (Object)snapshotPosition);
    }

    public long getLowestExporterPosition() {
        return this.state.getLowestPosition();
    }

    private ExporterEventFilter createEventFilter(List<ExporterContainer> containers) {
        List recordFilters = containers.stream().map(c -> ((ExporterContainer)c).context.getFilter()).collect(Collectors.toList());
        Map<RecordType, Boolean> acceptRecordTypes = Arrays.stream(RecordType.values()).collect(Collectors.toMap(Function.identity(), type -> recordFilters.stream().anyMatch(f -> f.acceptType(type))));
        Map<ValueType, Boolean> acceptValueTypes = Arrays.stream(ValueType.values()).collect(Collectors.toMap(Function.identity(), type -> recordFilters.stream().anyMatch(f -> f.acceptValue(type))));
        return new ExporterEventFilter(acceptRecordTypes, acceptValueTypes);
    }

    private void onFailure() {
        this.isOpened.set(false);
        this.actor.close();
    }

    private void onSnapshotRecovered() {
        this.onCommitPositionUpdatedCondition = this.actor.onCondition(this.getName() + "-on-commit-lastExportedPosition-updated", this::readNextEvent);
        this.logStream.registerOnCommitPositionUpdatedCondition(this.onCommitPositionUpdatedCondition);
        for (ExporterContainer container : this.containers) {
            container.position = this.state.getPosition(container.getId());
            if (container.position == -1L) {
                this.state.setPosition(container.getId(), -1L);
            }
            container.exporter.open((Controller)container);
        }
        this.clearExporterState();
        this.actor.submit(this::readNextEvent);
    }

    private void skipRecord() {
        this.actor.submit(this::readNextEvent);
        this.metrics.incrementEventsSkippedCount();
    }

    private void readNextEvent() {
        if (this.isOpened.get() && this.logStreamReader.hasNext() && !this.inExportingPhase) {
            LoggedEvent currentEvent = (LoggedEvent)this.logStreamReader.next();
            if (this.eventFilter == null || this.eventFilter.applies(currentEvent)) {
                this.inExportingPhase = true;
                this.exportEvent(currentEvent);
            } else {
                this.skipRecord();
            }
        }
    }

    private void exportEvent(LoggedEvent event) {
        ActorFuture wrapRetryFuture = this.recordWrapStrategy.runWithRetry(() -> {
            event.readMetadata((BufferReader)this.rawMetadata);
            this.recordExporter.wrap(event);
            return true;
        }, this::isClosed);
        this.actor.runOnCompletion(wrapRetryFuture, (b, t) -> {
            assert (t == null) : "Throwable must be null";
            ActorFuture retryFuture = this.exportingRetryStrategy.runWithRetry(this.recordExporter::export, this::isClosed);
            this.actor.runOnCompletion(retryFuture, (bool, throwable) -> {
                if (throwable != null) {
                    LOG.error(ERROR_MESSAGE_EXPORTING_ABORTED, (Object)event, throwable);
                    this.onFailure();
                } else {
                    this.lastExportedPosition = event.getPosition();
                    this.metrics.incrementEventsExportedCount();
                    this.inExportingPhase = false;
                    this.actor.submit(this::readNextEvent);
                }
            });
        });
    }

    public ExportersState getState() {
        return this.state;
    }

    private void clearExporterState() {
        List exporterIds = this.containers.stream().map(rec$ -> ((ExporterContainer)rec$).getId()).collect(Collectors.toList());
        this.state.visitPositions((exporterId, position) -> {
            if (!exporterIds.contains(exporterId)) {
                this.state.removePosition((String)exporterId);
                LOG.info("The exporter '{}' is not configured anymore. Its lastExportedPosition is removed from the state.", exporterId);
            }
        });
    }

    protected void onActorCloseRequested() {
        this.isOpened.set(false);
        for (ExporterContainer container : this.containers) {
            try {
                container.exporter.close();
            }
            catch (Exception e) {
                container.context.getLogger().error("Error on close", (Throwable)e);
            }
        }
    }

    protected void onActorClosing() {
        this.metrics.close();
        this.logStreamReader.close();
        if (this.onCommitPositionUpdatedCondition != null) {
            this.logStream.removeOnCommitPositionUpdatedCondition(this.onCommitPositionUpdatedCondition);
            this.onCommitPositionUpdatedCondition = null;
        }
    }

    protected void onActorClosed() {
        LOG.debug("Closed exporter director '{}'.", (Object)this.getName());
    }

    public boolean isClosed() {
        return !this.isOpened.get();
    }

    private class ExporterEventFilter
    implements EventFilter {
        private final RecordMetadata metadata = new RecordMetadata();
        private final Map<RecordType, Boolean> acceptRecordTypes;
        private final Map<ValueType, Boolean> acceptValueTypes;

        ExporterEventFilter(Map<RecordType, Boolean> acceptRecordTypes, Map<ValueType, Boolean> acceptValueTypes) {
            this.acceptRecordTypes = acceptRecordTypes;
            this.acceptValueTypes = acceptValueTypes;
        }

        public boolean applies(LoggedEvent event) {
            event.readMetadata((BufferReader)this.metadata);
            RecordType recordType = this.metadata.getRecordType();
            ValueType valueType = this.metadata.getValueType();
            return this.acceptRecordTypes.get(recordType) != false && this.acceptValueTypes.get(valueType) != false;
        }

        public String toString() {
            return "ExporterEventFilter{acceptRecordTypes=" + this.acceptRecordTypes + ", acceptValueTypes=" + this.acceptValueTypes + '}';
        }
    }

    private class RecordExporter {
        private final ExporterObjectMapper objectMapper = new ExporterObjectMapper();
        private final ExporterRecordMapper recordMapper = new ExporterRecordMapper(this.objectMapper);
        private Record record;
        private boolean shouldExecuteSideEffects;
        private int exporterIndex;

        private RecordExporter() {
        }

        void wrap(LoggedEvent rawEvent) {
            RecordMetadataImpl metadata = new RecordMetadataImpl(this.objectMapper, ExporterDirector.this.partitionId, ExporterDirector.this.rawMetadata.getIntent(), ExporterDirector.this.rawMetadata.getRecordType(), ExporterDirector.this.rawMetadata.getRejectionType(), BufferUtil.bufferAsString((DirectBuffer)ExporterDirector.this.rawMetadata.getRejectionReasonBuffer()), ExporterDirector.this.rawMetadata.getValueType());
            this.record = this.recordMapper.map(rawEvent, metadata);
            this.exporterIndex = 0;
            this.shouldExecuteSideEffects = this.record != null;
        }

        public boolean export() {
            if (!this.shouldExecuteSideEffects) {
                return true;
            }
            int exportersCount = ExporterDirector.this.containers.size();
            while (this.exporterIndex < exportersCount) {
                ExporterContainer container = (ExporterContainer)ExporterDirector.this.containers.get(this.exporterIndex);
                try {
                    if (container.position < this.record.getPosition() && container.acceptRecord(ExporterDirector.this.rawMetadata)) {
                        container.exporter.export(this.record);
                    }
                    ++this.exporterIndex;
                }
                catch (Exception ex) {
                    container.context.getLogger().error("Error exporting record {}", (Object)this.record, (Object)ex);
                    return false;
                }
            }
            return true;
        }
    }

    private class ExporterContainer
    implements Controller {
        private final ExporterContext context;
        private final Exporter exporter;
        private long position;

        ExporterContainer(ExporterDescriptor descriptor) {
            this.context = new ExporterContext(Loggers.getExporterLogger(descriptor.getId()), descriptor.getConfiguration());
            this.exporter = descriptor.newInstance();
        }

        public void updateLastExportedRecordPosition(long position) {
            ExporterDirector.this.actor.run(() -> {
                ExporterDirector.this.state.setPosition(this.getId(), position);
                this.position = position;
            });
        }

        public void scheduleTask(Duration delay, Runnable task) {
            ExporterDirector.this.actor.runDelayed(delay, task);
        }

        private String getId() {
            return this.context.getConfiguration().getId();
        }

        private boolean acceptRecord(RecordMetadata metadata) {
            Context.RecordFilter filter = this.context.getFilter();
            return filter.acceptType(metadata.getRecordType()) && filter.acceptValue(metadata.getValueType());
        }
    }
}

