/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.stream;

import io.zeebe.engine.processor.SnapshotMetrics;
import io.zeebe.util.metrics.Metric;
import io.zeebe.util.metrics.MetricsManager;

public class ExporterMetrics {
    private final Metric eventsExportedCountMetric;
    private final Metric eventsSkippedCountMetric;
    private final SnapshotMetrics snapshotMetrics;

    public ExporterMetrics(MetricsManager metricsManager, String processorName, String partitionId) {
        this.eventsExportedCountMetric = metricsManager.newMetric("exporter_events_count").type("counter").label("processor", processorName).label("action", "exported").label("partition", partitionId).create();
        this.eventsSkippedCountMetric = metricsManager.newMetric("exporter_events_count").type("counter").label("processor", processorName).label("action", "skipped").label("partition", partitionId).create();
        this.snapshotMetrics = new SnapshotMetrics(metricsManager, processorName, partitionId);
    }

    public void close() {
        this.eventsExportedCountMetric.close();
        this.eventsSkippedCountMetric.close();
        this.snapshotMetrics.close();
    }

    public void incrementEventsExportedCount() {
        this.eventsExportedCountMetric.incrementOrdered();
    }

    public void incrementEventsSkippedCount() {
        this.eventsSkippedCountMetric.incrementOrdered();
    }

    public SnapshotMetrics getSnapshotMetrics() {
        return this.snapshotMetrics;
    }
}

