/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.stream;

import io.zeebe.broker.exporter.ExporterObjectMapper;
import io.zeebe.broker.exporter.record.RecordImpl;
import io.zeebe.broker.exporter.record.value.DeploymentRecordValueImpl;
import io.zeebe.broker.exporter.record.value.ErrorRecordValueImpl;
import io.zeebe.broker.exporter.record.value.IncidentRecordValueImpl;
import io.zeebe.broker.exporter.record.value.JobBatchRecordValueImpl;
import io.zeebe.broker.exporter.record.value.JobRecordValueImpl;
import io.zeebe.broker.exporter.record.value.MessageRecordValueImpl;
import io.zeebe.broker.exporter.record.value.MessageStartEventSubscriptionRecordValueImpl;
import io.zeebe.broker.exporter.record.value.MessageSubscriptionRecordValueImpl;
import io.zeebe.broker.exporter.record.value.TimerRecordValueImpl;
import io.zeebe.broker.exporter.record.value.VariableDocumentRecordValueImpl;
import io.zeebe.broker.exporter.record.value.VariableRecordValueImpl;
import io.zeebe.broker.exporter.record.value.WorkflowInstanceCreationRecordValueImpl;
import io.zeebe.broker.exporter.record.value.WorkflowInstanceRecordValueImpl;
import io.zeebe.broker.exporter.record.value.WorkflowInstanceSubscriptionRecordValueImpl;
import io.zeebe.broker.exporter.record.value.deployment.DeployedWorkflowImpl;
import io.zeebe.broker.exporter.record.value.deployment.DeploymentResourceImpl;
import io.zeebe.broker.exporter.record.value.job.HeadersImpl;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.msgpack.value.LongValue;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.zeebe.protocol.impl.record.value.deployment.Workflow;
import io.zeebe.protocol.impl.record.value.error.ErrorRecord;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.zeebe.protocol.impl.record.value.job.JobHeaders;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.protocol.impl.record.value.message.WorkflowInstanceSubscriptionRecord;
import io.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.zeebe.protocol.impl.record.value.variable.VariableRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceCreationRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.RecordMetadata;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.value.DeploymentRecordValue;
import io.zeebe.protocol.record.value.ErrorRecordValue;
import io.zeebe.protocol.record.value.IncidentRecordValue;
import io.zeebe.protocol.record.value.JobRecordValue;
import io.zeebe.protocol.record.value.MessageRecordValue;
import io.zeebe.protocol.record.value.MessageSubscriptionRecordValue;
import io.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.zeebe.protocol.record.value.VariableRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceCreationRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceRecordValue;
import io.zeebe.protocol.record.value.WorkflowInstanceSubscriptionRecordValue;
import io.zeebe.protocol.record.value.deployment.DeployedWorkflow;
import io.zeebe.util.buffer.BufferUtil;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.agrona.DirectBuffer;
import org.agrona.io.DirectBufferInputStream;

public class ExporterRecordMapper {
    private final DirectBufferInputStream serderInputStream = new DirectBufferInputStream();
    private final ExporterObjectMapper objectMapper;

    public ExporterRecordMapper(ExporterObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Record map(LoggedEvent event, RecordMetadata metadata) {
        Function<DirectBuffer, RecordValue> valueSupplier;
        switch (metadata.getValueType()) {
            case DEPLOYMENT: {
                valueSupplier = this::ofDeploymentRecord;
                break;
            }
            case INCIDENT: {
                valueSupplier = this::ofIncidentRecord;
                break;
            }
            case JOB: {
                valueSupplier = this::ofJobRecord;
                break;
            }
            case MESSAGE: {
                valueSupplier = this::ofMessageRecord;
                break;
            }
            case MESSAGE_SUBSCRIPTION: {
                valueSupplier = this::ofMessageSubscriptionRecord;
                break;
            }
            case WORKFLOW_INSTANCE: {
                valueSupplier = this::ofWorkflowInstanceRecord;
                break;
            }
            case WORKFLOW_INSTANCE_SUBSCRIPTION: {
                valueSupplier = this::ofWorkflowInstanceSubscriptionRecord;
                break;
            }
            case JOB_BATCH: {
                valueSupplier = this::ofJobBatchRecord;
                break;
            }
            case TIMER: {
                valueSupplier = this::ofTimerRecord;
                break;
            }
            case MESSAGE_START_EVENT_SUBSCRIPTION: {
                valueSupplier = this::ofMessageStartEventSubscriptionRecord;
                break;
            }
            case VARIABLE: {
                valueSupplier = this::ofVariableRecord;
                break;
            }
            case VARIABLE_DOCUMENT: {
                valueSupplier = this::ofVariableDocumentRecord;
                break;
            }
            case WORKFLOW_INSTANCE_CREATION: {
                valueSupplier = this::ofWorkflowInstanceCreationRecord;
                break;
            }
            case ERROR: {
                valueSupplier = this::ofErrorRecord;
                break;
            }
            default: {
                return null;
            }
        }
        return this.newRecord(event, metadata, valueSupplier);
    }

    private <T extends RecordValue> RecordImpl<T> newRecord(LoggedEvent event, RecordMetadata metadata, Function<DirectBuffer, T> valueSupplier) {
        DirectBuffer eventBuffer = BufferUtil.cloneBuffer((DirectBuffer)event.getValueBuffer(), (int)event.getValueOffset(), (int)event.getValueLength());
        return new RecordImpl<RecordValue>(this.objectMapper, event.getKey(), event.getPosition(), Instant.ofEpochMilli(event.getTimestamp()), event.getProducerId(), event.getSourceEventPosition(), metadata, () -> (RecordValue)valueSupplier.apply(eventBuffer));
    }

    private JobRecordValue ofJobRecord(DirectBuffer valueBuffer) {
        JobRecord record = new JobRecord();
        record.wrap(valueBuffer);
        return this.ofJobRecord(record);
    }

    private JobRecordValue ofJobRecord(JobRecord record) {
        JobHeaders jobHeaders = record.getJobHeaders();
        HeadersImpl headers = new HeadersImpl(this.asString(jobHeaders.getBpmnProcessIdBuffer()), this.asString(jobHeaders.getElementIdBuffer()), jobHeaders.getElementInstanceKey(), jobHeaders.getWorkflowInstanceKey(), jobHeaders.getWorkflowKey(), jobHeaders.getWorkflowDefinitionVersion());
        Instant deadline = record.getDeadlineLong() != Long.MIN_VALUE ? Instant.ofEpochMilli(record.getDeadlineLong()) : null;
        return new JobRecordValueImpl(this.objectMapper, this.asJson(record.getVariablesBuffer()), this.asMsgPackMap(record.getVariablesBuffer()), this.asString(record.getTypeBuffer()), this.asString(record.getWorkerBuffer()), deadline, headers, this.asMsgPackMap(record.getCustomHeadersBuffer()), record.getRetries(), this.asString(record.getErrorMessageBuffer()));
    }

    private DeploymentRecordValue ofDeploymentRecord(DirectBuffer valueBuffer) {
        ArrayList<DeployedWorkflow> deployedWorkflows = new ArrayList<DeployedWorkflow>();
        ArrayList<io.zeebe.protocol.record.value.deployment.DeploymentResource> resources = new ArrayList<io.zeebe.protocol.record.value.deployment.DeploymentResource>();
        DeploymentRecord record = new DeploymentRecord();
        record.wrap(valueBuffer);
        for (Workflow workflow : record.workflows()) {
            deployedWorkflows.add(new DeployedWorkflowImpl(this.asString(workflow.getBpmnProcessIdBuffer()), this.asString(workflow.getResourceNameBuffer()), workflow.getKey(), workflow.getVersion()));
        }
        for (DeploymentResource resource : record.resources()) {
            resources.add(new DeploymentResourceImpl(this.asByteArray(resource.getResourceBuffer()), resource.getResourceType(), this.asString(resource.getResourceNameBuffer())));
        }
        return new DeploymentRecordValueImpl(this.objectMapper, deployedWorkflows, resources);
    }

    private IncidentRecordValue ofIncidentRecord(DirectBuffer valueBuffer) {
        IncidentRecord record = new IncidentRecord();
        record.wrap(valueBuffer);
        return new IncidentRecordValueImpl(this.objectMapper, record.getErrorTypeEnum().name(), this.asString(record.getErrorMessageBuffer()), this.asString(record.getBpmnProcessIdBuffer()), this.asString(record.getElementIdBuffer()), record.getWorkflowKey(), record.getWorkflowInstanceKey(), record.getElementInstanceKey(), record.getJobKey(), record.getVariableScopeKey());
    }

    private MessageRecordValue ofMessageRecord(DirectBuffer valueBuffer) {
        MessageRecord record = new MessageRecord();
        record.wrap(valueBuffer);
        return new MessageRecordValueImpl(this.objectMapper, this.asJson(record.getVariablesBuffer()), this.asMsgPackMap(record.getVariablesBuffer()), this.asString(record.getNameBuffer()), this.asString(record.getMessageIdBuffer()), this.asString(record.getCorrelationKeyBuffer()), record.getTimeToLive());
    }

    private MessageSubscriptionRecordValue ofMessageSubscriptionRecord(DirectBuffer valueBuffer) {
        MessageSubscriptionRecord record = new MessageSubscriptionRecord();
        record.wrap(valueBuffer);
        return new MessageSubscriptionRecordValueImpl(this.objectMapper, this.asString(record.getMessageNameBuffer()), this.asString(record.getCorrelationKeyBuffer()), record.getWorkflowInstanceKey(), record.getElementInstanceKey());
    }

    private MessageStartEventSubscriptionRecordValueImpl ofMessageStartEventSubscriptionRecord(DirectBuffer valueBuffer) {
        MessageStartEventSubscriptionRecord record = new MessageStartEventSubscriptionRecord();
        record.wrap(valueBuffer);
        return new MessageStartEventSubscriptionRecordValueImpl(this.objectMapper, record.getWorkflowKey(), this.asString(record.getStartEventIdBuffer()), this.asString(record.getMessageNameBuffer()));
    }

    private WorkflowInstanceRecordValue ofWorkflowInstanceRecord(DirectBuffer valueBuffer) {
        WorkflowInstanceRecord record = new WorkflowInstanceRecord();
        record.wrap(valueBuffer);
        return new WorkflowInstanceRecordValueImpl(this.objectMapper, this.asString(record.getBpmnProcessIdBuffer()), this.asString(record.getElementIdBuffer()), record.getVersion(), record.getWorkflowKey(), record.getWorkflowInstanceKey(), record.getFlowScopeKey(), record.getBpmnElementType());
    }

    private WorkflowInstanceSubscriptionRecordValue ofWorkflowInstanceSubscriptionRecord(DirectBuffer valueBuffer) {
        WorkflowInstanceSubscriptionRecord record = new WorkflowInstanceSubscriptionRecord();
        record.wrap(valueBuffer);
        return new WorkflowInstanceSubscriptionRecordValueImpl(this.objectMapper, this.asJson(record.getVariablesBuffer()), this.asMsgPackMap(record.getVariablesBuffer()), this.asString(record.getMessageNameBuffer()), record.getWorkflowInstanceKey(), record.getElementInstanceKey());
    }

    private RecordValue ofJobBatchRecord(DirectBuffer valueBuffer) {
        JobBatchRecord record = new JobBatchRecord();
        record.wrap(valueBuffer);
        List<Long> jobKeys = StreamSupport.stream(record.jobKeys().spliterator(), false).map(LongValue::getValue).collect(Collectors.toList());
        List<JobRecordValue> jobs = StreamSupport.stream(record.jobs().spliterator(), false).map(this::ofJobRecord).collect(Collectors.toList());
        return new JobBatchRecordValueImpl(this.objectMapper, this.asString(record.getTypeBuffer()), this.asString(record.getWorkerBuffer()), Duration.ofMillis(record.getTimeoutLong()), record.getMaxJobsToActivate(), jobKeys, jobs, record.getTruncated());
    }

    private RecordValue ofTimerRecord(DirectBuffer valueBuffer) {
        TimerRecord record = new TimerRecord();
        record.wrap(valueBuffer);
        return new TimerRecordValueImpl(this.objectMapper, record.getElementInstanceKey(), record.getWorkflowInstanceKey(), record.getDueDate(), this.asString(record.getHandlerNodeId()), record.getRepetitions(), record.getWorkflowKey());
    }

    private VariableRecordValue ofVariableRecord(DirectBuffer valueBuffer) {
        VariableRecord record = new VariableRecord();
        record.wrap(valueBuffer);
        return new VariableRecordValueImpl(this.objectMapper, this.asString(record.getNameBuffer()), this.asJson(record.getValueBuffer()), record.getScopeKey(), record.getWorkflowInstanceKey(), record.getWorkflowKey());
    }

    private VariableDocumentRecordValue ofVariableDocumentRecord(DirectBuffer valueBuffer) {
        VariableDocumentRecord record = new VariableDocumentRecord();
        record.wrap(valueBuffer);
        return new VariableDocumentRecordValueImpl(this.objectMapper, record.getScopeKey(), record.getUpdateSemantics(), this.asMsgPackMap(record.getDocumentBuffer()));
    }

    private WorkflowInstanceCreationRecordValue ofWorkflowInstanceCreationRecord(DirectBuffer valueBuffer) {
        WorkflowInstanceCreationRecord record = new WorkflowInstanceCreationRecord();
        record.wrap(valueBuffer);
        return new WorkflowInstanceCreationRecordValueImpl(this.objectMapper, this.asString(record.getBpmnProcessIdBuffer()), record.getVersion(), record.getKey(), record.getInstanceKey(), this.asMsgPackMap(record.getVariablesBuffer()));
    }

    private ErrorRecordValue ofErrorRecord(DirectBuffer valueBuffer) {
        ErrorRecord record = new ErrorRecord();
        record.wrap(valueBuffer);
        return new ErrorRecordValueImpl(this.objectMapper, this.asString(record.getExceptionMessageBuffer()), this.asString(record.getStacktraceBuffer()), record.getErrorEventPosition(), record.getWorkflowInstanceKey());
    }

    private byte[] asByteArray(DirectBuffer buffer) {
        return BufferUtil.bufferAsArray((DirectBuffer)buffer);
    }

    private String asString(DirectBuffer buffer) {
        return BufferUtil.bufferAsString((DirectBuffer)buffer);
    }

    private Supplier<Map<String, Object>> asMsgPackMap(DirectBuffer msgPackEncoded) {
        return () -> {
            this.serderInputStream.wrap(msgPackEncoded);
            return this.objectMapper.fromMsgpackAsMap((InputStream)this.serderInputStream);
        };
    }

    private Supplier<String> asJson(DirectBuffer msgPackEncoded) {
        return () -> {
            this.serderInputStream.wrap(msgPackEncoded);
            return MsgPackConverter.convertToJson((InputStream)this.serderInputStream);
        };
    }
}

