/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.stream;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.state.ZbColumnFamilies;
import java.util.function.BiConsumer;
import org.agrona.DirectBuffer;
import org.agrona.collections.LongArrayList;

public class ExportersState {
    public static final long VALUE_NOT_FOUND = -1L;
    private final DbString exporterId = new DbString();
    private final DbLong position = new DbLong();
    private final ColumnFamily<DbString, DbLong> exporterPositionColumnFamily;

    public ExportersState(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext) {
        this.exporterPositionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.EXPORTER, dbContext, (DbKey)this.exporterId, (DbValue)this.position);
    }

    public void setPosition(String exporterId, long position) {
        this.exporterId.wrapString(exporterId);
        this.setPosition(position);
    }

    private void setPosition(long position) {
        this.position.wrapLong(position);
        this.exporterPositionColumnFamily.put((DbKey)this.exporterId, (DbValue)this.position);
    }

    public void setPositionIfGreater(String exporterId, long position) {
        this.exporterId.wrapString(exporterId);
        this.setPositionIfGreater(position);
    }

    private void setPositionIfGreater(long position) {
        long oldPosition = this.getPosition();
        if (oldPosition < position) {
            this.setPosition(position);
        }
    }

    public long getPosition(String exporterId) {
        this.exporterId.wrapString(exporterId);
        return this.getPosition();
    }

    public long getPosition(DirectBuffer exporterId) {
        this.exporterId.wrapBuffer(exporterId);
        return this.getPosition();
    }

    private long getPosition() {
        DbLong zbLong = (DbLong)this.exporterPositionColumnFamily.get((DbKey)this.exporterId);
        return zbLong == null ? -1L : zbLong.getValue();
    }

    public void visitPositions(BiConsumer<String, Long> consumer) {
        this.exporterPositionColumnFamily.forEach((exporterId, position) -> consumer.accept(exporterId.toString(), position.getValue()));
    }

    public long getLowestPosition() {
        LongArrayList positions = new LongArrayList();
        this.visitPositions((id, pos) -> positions.addLong(pos.longValue()));
        return positions.longStream().min().orElse(-1L);
    }

    public void removePosition(String exporter) {
        this.exporterId.wrapString(exporter);
        this.exporterPositionColumnFamily.delete((DbKey)this.exporterId);
    }

    public boolean hasExporters() {
        return !this.exporterPositionColumnFamily.isEmpty();
    }
}

