/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams.delete;

import io.zeebe.broker.logstreams.state.StatePositionSupplier;
import io.zeebe.logstreams.impl.delete.DeletionService;
import io.zeebe.logstreams.log.LogStream;

public class FollowerLogStreamDeletionService
implements DeletionService {
    private final LogStream logStream;
    private StatePositionSupplier positionSupplier;

    public FollowerLogStreamDeletionService(LogStream logStream, StatePositionSupplier positionSupplier) {
        this.logStream = logStream;
        this.positionSupplier = positionSupplier;
    }

    public void delete(long position) {
        long minPosition = Math.min(position, this.getMinimumExportedPosition());
        this.logStream.delete(minPosition);
    }

    private long getMinimumExportedPosition() {
        return this.positionSupplier.getMinimumExportedPosition();
    }
}

