/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams.delete;

import io.zeebe.broker.exporter.ExporterManagerService;
import io.zeebe.logstreams.impl.delete.DeletionService;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;

public class LeaderLogStreamDeletionService
implements DeletionService,
Service {
    private final Injector<ExporterManagerService> exporterManagerInjector = new Injector();
    private final LogStream logStream;
    private ExporterManagerService exporterManagerService;

    public LeaderLogStreamDeletionService(LogStream logStream) {
        this.logStream = logStream;
    }

    public void start(ServiceStartContext startContext) {
        this.exporterManagerService = (ExporterManagerService)this.exporterManagerInjector.getValue();
    }

    public void delete(long position) {
        long minPosition = Math.min(position, this.getMinimumExportedPosition());
        this.logStream.delete(minPosition);
    }

    private long getMinimumExportedPosition() {
        return this.exporterManagerService.getLowestExporterPosition();
    }

    public void stop(ServiceStopContext stopContext) {
    }

    public LeaderLogStreamDeletionService get() {
        return this;
    }

    public Injector<ExporterManagerService> getExporterManagerInjector() {
        return this.exporterManagerInjector;
    }
}

