/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams.restore;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.zeebe.broker.logstreams.restore.BrokerRestoreFactory;
import io.zeebe.broker.logstreams.restore.SbeLogReplicationRequest;
import io.zeebe.broker.logstreams.restore.SbeLogReplicationResponse;
import io.zeebe.broker.logstreams.restore.SbeRestoreInfoRequest;
import io.zeebe.broker.logstreams.restore.SbeRestoreInfoResponse;
import io.zeebe.broker.logstreams.restore.SbeSnapshotRestoreRequest;
import io.zeebe.broker.logstreams.restore.SbeSnapshotRestoreResponse;
import io.zeebe.distributedlog.restore.RestoreClient;
import io.zeebe.distributedlog.restore.RestoreInfoRequest;
import io.zeebe.distributedlog.restore.RestoreInfoResponse;
import io.zeebe.distributedlog.restore.log.LogReplicationRequest;
import io.zeebe.distributedlog.restore.log.LogReplicationResponse;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreRequest;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreResponse;
import io.zeebe.util.ZbLogger;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public class BrokerRestoreClient
implements RestoreClient {
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(5L);
    private final ClusterCommunicationService communicationService;
    private final String logReplicationTopic;
    private final String restoreInfoTopic;
    private final String snapshotRequestTopic;
    private final Logger logger;

    public BrokerRestoreClient(ClusterCommunicationService communicationService, int partitionId) {
        this(communicationService, BrokerRestoreFactory.getLogReplicationTopic(partitionId), BrokerRestoreFactory.getRestoreInfoTopic(partitionId), BrokerRestoreFactory.getSnapshotRequestTopic(partitionId), (Logger)new ZbLogger(String.format("%s-%d", BrokerRestoreClient.class.getName(), partitionId)));
    }

    public BrokerRestoreClient(ClusterCommunicationService communicationService, String logReplicationTopic, String restoreInfoTopic, String snapshotRequestTopic, Logger logger) {
        this.communicationService = communicationService;
        this.logReplicationTopic = logReplicationTopic;
        this.restoreInfoTopic = restoreInfoTopic;
        this.snapshotRequestTopic = snapshotRequestTopic;
        this.logger = logger;
    }

    public CompletableFuture<LogReplicationResponse> requestLogReplication(MemberId server, LogReplicationRequest request) {
        this.logger.trace("Sending log replication request {} to {} on topic {}", new Object[]{request, server, this.logReplicationTopic});
        return this.communicationService.send(this.logReplicationTopic, (Object)request, SbeLogReplicationRequest::serialize, SbeLogReplicationResponse::new, server, DEFAULT_REQUEST_TIMEOUT);
    }

    public CompletableFuture<RestoreInfoResponse> requestRestoreInfo(MemberId server, RestoreInfoRequest request) {
        this.logger.trace("Sending restore info request {} to {} on topic {}", new Object[]{request, server, this.restoreInfoTopic});
        return this.communicationService.send(this.restoreInfoTopic, (Object)request, SbeRestoreInfoRequest::serialize, SbeRestoreInfoResponse::new, server, DEFAULT_REQUEST_TIMEOUT);
    }

    public CompletableFuture<SnapshotRestoreResponse> requestSnapshotChunk(MemberId server, SnapshotRestoreRequest request) {
        return this.communicationService.send(this.snapshotRequestTopic, (Object)request, SbeSnapshotRestoreRequest::serialize, SbeSnapshotRestoreResponse::new, server, DEFAULT_REQUEST_TIMEOUT);
    }
}

