/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams.restore;

import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionService;
import io.zeebe.broker.logstreams.restore.BrokerRestoreClient;
import io.zeebe.broker.logstreams.restore.BrokerSnapshotRestoreContext;
import io.zeebe.broker.logstreams.restore.CyclicPartitionNodeProvider;
import io.zeebe.broker.logstreams.state.StatePositionSupplier;
import io.zeebe.distributedlog.StorageConfiguration;
import io.zeebe.distributedlog.impl.LogstreamConfig;
import io.zeebe.distributedlog.restore.RestoreClient;
import io.zeebe.distributedlog.restore.RestoreFactory;
import io.zeebe.distributedlog.restore.RestoreNodeProvider;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreContext;
import io.zeebe.engine.state.DefaultZeebeDbFactory;
import io.zeebe.engine.state.StateStorageFactory;
import io.zeebe.logstreams.spi.SnapshotController;
import io.zeebe.logstreams.state.StateSnapshotController;
import io.zeebe.logstreams.state.StateStorage;
import org.slf4j.Logger;

public class BrokerRestoreFactory
implements RestoreFactory {
    private final ClusterCommunicationService communicationService;
    private final PartitionService partitionService;
    private final String partitionGroupName;
    private final String localMemberId;

    public BrokerRestoreFactory(ClusterCommunicationService communicationService, PartitionService partitionService, String partitionGroupName, String localMemberId) {
        this.communicationService = communicationService;
        this.partitionService = partitionService;
        this.partitionGroupName = partitionGroupName;
        this.localMemberId = localMemberId;
    }

    public RestoreNodeProvider createNodeProvider(int partitionId) {
        return new CyclicPartitionNodeProvider(() -> this.getPartition(partitionId), this.localMemberId);
    }

    public RestoreClient createClient(int partitionId) {
        return new BrokerRestoreClient(this.communicationService, partitionId);
    }

    public SnapshotRestoreContext createSnapshotRestoreContext(int partitionId, Logger logger) {
        StorageConfiguration configuration = (StorageConfiguration)LogstreamConfig.getConfig((String)this.localMemberId, (int)partitionId).join();
        StateStorage restoreStateStorage = new StateStorageFactory(configuration.getStatesDirectory()).create(partitionId, "zb-stream-processor", "-restore-log");
        StateSnapshotController stateSnapshotController = new StateSnapshotController(DefaultZeebeDbFactory.DEFAULT_DB_FACTORY, restoreStateStorage);
        StatePositionSupplier positionSupplier = new StatePositionSupplier((SnapshotController)stateSnapshotController, partitionId, this.localMemberId, logger);
        return new BrokerSnapshotRestoreContext(positionSupplier, restoreStateStorage);
    }

    private Partition getPartition(int partitionId) {
        PartitionGroup group = this.partitionService.getPartitionGroup(this.partitionGroupName);
        return group.getPartition(PartitionId.from((String)this.partitionGroupName, (int)partitionId));
    }

    static String getLogReplicationTopic(int partitionId) {
        return String.format("log-replication-%d", partitionId);
    }

    static String getRestoreInfoTopic(int partitionId) {
        return String.format("restore-info-%d", partitionId);
    }

    static String getSnapshotRequestTopic(int partitionId) {
        return String.format("snapshot-request-%d", partitionId);
    }

    static String getSnapshotInfoRequestTopic(int partitionId) {
        return String.format("snapshot-info-request-%d", partitionId);
    }
}

