/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams.restore;

import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.zeebe.broker.logstreams.restore.BrokerRestoreFactory;
import io.zeebe.broker.logstreams.restore.SbeLogReplicationRequest;
import io.zeebe.broker.logstreams.restore.SbeLogReplicationResponse;
import io.zeebe.broker.logstreams.restore.SbeRestoreInfoRequest;
import io.zeebe.broker.logstreams.restore.SbeRestoreInfoResponse;
import io.zeebe.broker.logstreams.restore.SbeSnapshotRestoreRequest;
import io.zeebe.broker.logstreams.restore.SbeSnapshotRestoreResponse;
import io.zeebe.distributedlog.restore.RestoreServer;
import io.zeebe.distributedlog.restore.impl.DefaultRestoreInfoRequestHandler;
import io.zeebe.distributedlog.restore.log.impl.DefaultLogReplicationRequestHandler;
import io.zeebe.distributedlog.restore.snapshot.impl.DefaultSnapshotRequestHandler;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.spi.SnapshotController;
import io.zeebe.util.ZbLogger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;

public class BrokerRestoreServer
implements RestoreServer {
    private final ClusterCommunicationService communicationService;
    private final String logReplicationTopic;
    private final String restoreInfoTopic;
    private final String snapshotRequestTopic;
    private final String snapshotInfoRequestTopic;
    private final ExecutorService executor;
    private final Logger logger;

    public BrokerRestoreServer(ClusterCommunicationService communicationService, int partitionId) {
        this(communicationService, BrokerRestoreFactory.getLogReplicationTopic(partitionId), BrokerRestoreFactory.getRestoreInfoTopic(partitionId), BrokerRestoreFactory.getSnapshotRequestTopic(partitionId), BrokerRestoreFactory.getSnapshotInfoRequestTopic(partitionId), Executors.newSingleThreadExecutor(r -> new Thread(r, String.format(BrokerRestoreServer.class.getName(), partitionId))), (Logger)new ZbLogger(String.format(BrokerRestoreServer.class.getName(), partitionId)));
    }

    public BrokerRestoreServer(ClusterCommunicationService communicationService, String logReplicationTopic, String restoreInfoTopic, String snapshotRequestTopic, String snapshotInfoRequestTopic, ExecutorService executor, Logger logger) {
        this.communicationService = communicationService;
        this.logReplicationTopic = logReplicationTopic;
        this.restoreInfoTopic = restoreInfoTopic;
        this.snapshotRequestTopic = snapshotRequestTopic;
        this.snapshotInfoRequestTopic = snapshotInfoRequestTopic;
        this.executor = executor;
        this.logger = logger;
    }

    public CompletableFuture<Void> start(LogStream logStream, SnapshotController snapshotController) {
        DefaultLogReplicationRequestHandler logReplicationHandler = new DefaultLogReplicationRequestHandler(logStream);
        DefaultRestoreInfoRequestHandler restoreInfoHandler = new DefaultRestoreInfoRequestHandler(logStream, snapshotController);
        DefaultSnapshotRequestHandler snapshotRequestHandler = new DefaultSnapshotRequestHandler(snapshotController);
        return ((CompletableFuture)((CompletableFuture)this.serve((RestoreServer.LogReplicationRequestHandler)logReplicationHandler).thenCompose(arg_0 -> this.lambda$start$1((RestoreServer.RestoreInfoRequestHandler)restoreInfoHandler, arg_0))).thenCompose(arg_0 -> this.lambda$start$2((RestoreServer.SnapshotRequestHandler)snapshotRequestHandler, arg_0))).thenRun(this::logServerStart);
    }

    public void close() {
        this.communicationService.unsubscribe(this.logReplicationTopic);
        this.communicationService.unsubscribe(this.restoreInfoTopic);
        this.communicationService.unsubscribe(this.snapshotRequestTopic);
        this.communicationService.unsubscribe(this.snapshotInfoRequestTopic);
        this.executor.shutdownNow();
        this.logger.debug("Closed restore server for topics: {}, {}, {}, {}", new Object[]{this.logReplicationTopic, this.restoreInfoTopic, this.snapshotRequestTopic, this.snapshotInfoRequestTopic});
    }

    public CompletableFuture<Void> serve(RestoreServer.LogReplicationRequestHandler handler) {
        this.logger.trace("Subscribed handler {} to topic {}", (Object)this.logReplicationTopic, (Object)handler);
        return this.communicationService.subscribe(this.logReplicationTopic, SbeLogReplicationRequest::new, arg_0 -> ((RestoreServer.LogReplicationRequestHandler)handler).onReplicationRequest(arg_0), SbeLogReplicationResponse::serialize, (Executor)this.executor);
    }

    public CompletableFuture<Void> serve(RestoreServer.RestoreInfoRequestHandler handler) {
        this.logger.trace("Subscribed handler {} to topic {}", (Object)this.restoreInfoTopic, (Object)handler);
        return this.communicationService.subscribe(this.restoreInfoTopic, SbeRestoreInfoRequest::new, arg_0 -> ((RestoreServer.RestoreInfoRequestHandler)handler).onRestoreInfoRequest(arg_0), SbeRestoreInfoResponse::serialize, (Executor)this.executor);
    }

    public CompletableFuture<Void> serve(RestoreServer.SnapshotRequestHandler handler) {
        this.logger.trace("Subscribed handler {} to topic {}", (Object)this.snapshotRequestTopic, (Object)handler);
        return this.communicationService.subscribe(this.snapshotRequestTopic, SbeSnapshotRestoreRequest::new, arg_0 -> ((RestoreServer.SnapshotRequestHandler)handler).onSnapshotRequest(arg_0), SbeSnapshotRestoreResponse::serialize, (Executor)this.executor);
    }

    private void logServerStart() {
        this.logger.debug("Started restore server for topics: {}, {}, {}, {}", new Object[]{this.logReplicationTopic, this.restoreInfoTopic, this.snapshotRequestTopic, this.snapshotInfoRequestTopic});
    }

    private /* synthetic */ CompletionStage lambda$start$2(RestoreServer.SnapshotRequestHandler snapshotRequestHandler, Void nothing) {
        return this.serve(snapshotRequestHandler);
    }

    private /* synthetic */ CompletionStage lambda$start$1(RestoreServer.RestoreInfoRequestHandler restoreInfoHandler, Void nothing) {
        return this.serve(restoreInfoHandler);
    }
}

