/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams.restore;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.Partition;
import io.zeebe.distributedlog.restore.RestoreNodeProvider;
import io.zeebe.util.ZbLogger;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class CyclicPartitionNodeProvider
implements RestoreNodeProvider {
    private final Supplier<Partition> partitionSupplier;
    private final String localMemberId;
    private final Queue<MemberId> members;
    private final Logger logger;

    public CyclicPartitionNodeProvider(Supplier<Partition> partitionSupplier, String localMemberId) {
        this.partitionSupplier = partitionSupplier;
        this.localMemberId = localMemberId;
        this.members = new ArrayDeque<MemberId>();
        this.logger = new ZbLogger(String.format("%s-%s", CyclicPartitionNodeProvider.class.getCanonicalName(), localMemberId));
    }

    public MemberId provideRestoreNode() {
        return this.memberQueue().poll();
    }

    private Queue<MemberId> memberQueue() {
        if (this.members.isEmpty()) {
            Partition partition = this.partitionSupplier.get();
            if (partition != null) {
                partition.members().stream().filter(m -> !((String)((Object)m.id())).equals(this.localMemberId)).forEach(this.members::add);
            } else {
                this.logger.warn("No partition provided, cannot provide a restore node");
            }
        }
        return this.members;
    }
}

