/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams.restore;

import io.zeebe.clustering.management.BooleanType;
import io.zeebe.clustering.management.LogReplicationRequestDecoder;
import io.zeebe.clustering.management.LogReplicationRequestEncoder;
import io.zeebe.distributedlog.restore.log.LogReplicationRequest;
import io.zeebe.engine.util.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class SbeLogReplicationRequest
extends SbeBufferWriterReader<LogReplicationRequestEncoder, LogReplicationRequestDecoder>
implements LogReplicationRequest {
    private final LogReplicationRequestEncoder encoder = new LogReplicationRequestEncoder();
    private final LogReplicationRequestDecoder decoder = new LogReplicationRequestDecoder();
    private long fromPosition;
    private long toPosition;
    private boolean includeFromPosition;

    public SbeLogReplicationRequest() {
    }

    public SbeLogReplicationRequest(LogReplicationRequest other) {
        this.reset();
        this.wrap(other);
    }

    public SbeLogReplicationRequest(long fromPosition, long toPosition, boolean includeFromPosition) {
        this.fromPosition = fromPosition;
        this.toPosition = toPosition;
        this.includeFromPosition = includeFromPosition;
    }

    public SbeLogReplicationRequest(byte[] serialized) {
        this.reset();
        this.wrap((DirectBuffer)new UnsafeBuffer(serialized));
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.fromPosition = this.decoder.fromPosition();
        this.toPosition = this.decoder.toPosition();
        this.includeFromPosition = this.decoder.includeFromPosition() == BooleanType.TRUE;
    }

    public void wrap(LogReplicationRequest other) {
        this.setFromPosition(other.getFromPosition());
        this.setToPosition(other.getToPosition());
        this.setIncludeFromPosition(other.includeFromPosition());
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.fromPosition(this.fromPosition).toPosition(this.toPosition).includeFromPosition(this.includeFromPosition ? BooleanType.TRUE : BooleanType.FALSE);
    }

    public void reset() {
        super.reset();
        this.fromPosition = LogReplicationRequestEncoder.fromPositionNullValue();
        this.toPosition = LogReplicationRequestEncoder.toPositionNullValue();
        this.includeFromPosition = false;
    }

    public long getFromPosition() {
        return this.fromPosition;
    }

    public void setFromPosition(long fromPosition) {
        this.fromPosition = fromPosition;
    }

    public long getToPosition() {
        return this.toPosition;
    }

    public void setToPosition(long toPosition) {
        this.toPosition = toPosition;
    }

    public boolean includeFromPosition() {
        return this.includeFromPosition;
    }

    public void setIncludeFromPosition(boolean include) {
        this.includeFromPosition = include;
    }

    public static byte[] serialize(LogReplicationRequest request) {
        return new SbeLogReplicationRequest(request).toBytes();
    }

    protected LogReplicationRequestEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected LogReplicationRequestDecoder getBodyDecoder() {
        return this.decoder;
    }
}

