/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams.restore;

import io.zeebe.clustering.management.BooleanType;
import io.zeebe.clustering.management.LogReplicationResponseDecoder;
import io.zeebe.clustering.management.LogReplicationResponseEncoder;
import io.zeebe.distributedlog.restore.log.LogReplicationResponse;
import io.zeebe.engine.util.SbeBufferWriterReader;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class SbeLogReplicationResponse
extends SbeBufferWriterReader<LogReplicationResponseEncoder, LogReplicationResponseDecoder>
implements LogReplicationResponse {
    private final LogReplicationResponseEncoder encoder = new LogReplicationResponseEncoder();
    private final LogReplicationResponseDecoder decoder = new LogReplicationResponseDecoder();
    private final DirectBuffer serializedEvents = new UnsafeBuffer();
    private long toPosition;
    private boolean moreAvailable;

    public SbeLogReplicationResponse() {
    }

    public SbeLogReplicationResponse(LogReplicationResponse other) {
        this.reset();
        this.wrap(other);
    }

    public SbeLogReplicationResponse(long toPosition, boolean moreAvailable, byte[] serializedEvents) {
        this.toPosition = toPosition;
        this.moreAvailable = moreAvailable;
        this.serializedEvents.wrap(serializedEvents);
    }

    public SbeLogReplicationResponse(byte[] serialized) {
        this.reset();
        this.wrap((DirectBuffer)new UnsafeBuffer(serialized));
    }

    public void reset() {
        super.reset();
        this.toPosition = LogReplicationResponseEncoder.toPositionNullValue();
        this.moreAvailable = false;
        this.serializedEvents.wrap(0L, 0);
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.toPosition = this.decoder.toPosition();
        this.moreAvailable = this.decoder.moreAvailable() == BooleanType.TRUE;
        this.decoder.wrapSerializedEvents(this.serializedEvents);
    }

    public void wrap(LogReplicationResponse other) {
        this.setToPosition(other.getToPosition());
        this.setSerializedEvents(other.getSerializedEvents());
        this.setMoreAvailable(other.hasMoreAvailable());
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.toPosition(this.toPosition);
        this.encoder.putSerializedEvents(this.serializedEvents, 0, this.serializedEvents.capacity());
        this.encoder.moreAvailable(this.moreAvailable ? BooleanType.TRUE : BooleanType.FALSE);
    }

    public int getLength() {
        return super.getLength() + LogReplicationResponseEncoder.serializedEventsHeaderLength() + this.serializedEvents.capacity();
    }

    public boolean hasMoreAvailable() {
        return this.moreAvailable;
    }

    public byte[] getSerializedEvents() {
        return BufferUtil.bufferAsArray((DirectBuffer)this.serializedEvents);
    }

    public long getToPosition() {
        return this.toPosition;
    }

    public void setToPosition(long toPosition) {
        this.toPosition = toPosition;
    }

    public void setMoreAvailable(boolean moreAvailable) {
        this.moreAvailable = moreAvailable;
    }

    public void setSerializedEvents(byte[] serializedEvents) {
        this.serializedEvents.wrap(serializedEvents);
    }

    public void setSerializedEvents(DirectBuffer serializedEvents, int offset, int length) {
        this.serializedEvents.wrap(serializedEvents, offset, length);
    }

    public static byte[] serialize(LogReplicationResponse response) {
        return new SbeLogReplicationResponse(response).toBytes();
    }

    public boolean isValid() {
        return this.toPosition != LogReplicationResponseEncoder.toPositionNullValue() && this.serializedEvents.capacity() > 0;
    }

    protected LogReplicationResponseEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected LogReplicationResponseDecoder getBodyDecoder() {
        return this.decoder;
    }
}

