/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams.restore;

import io.zeebe.clustering.management.RestoreInfoRequestDecoder;
import io.zeebe.clustering.management.RestoreInfoRequestEncoder;
import io.zeebe.distributedlog.restore.RestoreInfoRequest;
import io.zeebe.distributedlog.restore.impl.DefaultRestoreInfoRequest;
import io.zeebe.engine.util.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class SbeRestoreInfoRequest
extends SbeBufferWriterReader<RestoreInfoRequestEncoder, RestoreInfoRequestDecoder>
implements RestoreInfoRequest {
    private final RestoreInfoRequestDecoder decoder;
    private final RestoreInfoRequestEncoder encoder;
    private final DefaultRestoreInfoRequest delegate = new DefaultRestoreInfoRequest();

    public SbeRestoreInfoRequest() {
        this.encoder = new RestoreInfoRequestEncoder();
        this.decoder = new RestoreInfoRequestDecoder();
        this.reset();
    }

    public SbeRestoreInfoRequest(RestoreInfoRequest other) {
        this();
        this.setBackupPosition(other.getBackupPosition());
        this.setLatestLocalPosition(other.getLatestLocalPosition());
    }

    public SbeRestoreInfoRequest(byte[] serialized) {
        this();
        this.wrap((DirectBuffer)new UnsafeBuffer(serialized));
    }

    public void reset() {
        super.reset();
        this.setLatestLocalPosition(RestoreInfoRequestEncoder.latestLocalPositionNullValue());
        this.setBackupPosition(RestoreInfoRequestEncoder.backupPositionNullValue());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.setLatestLocalPosition(this.decoder.latestLocalPosition());
        this.setBackupPosition(this.decoder.backupPosition());
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.backupPosition(this.getBackupPosition());
        this.encoder.latestLocalPosition(this.getLatestLocalPosition());
    }

    public long getLatestLocalPosition() {
        return this.delegate.getLatestLocalPosition();
    }

    public void setLatestLocalPosition(long latestLocalPosition) {
        this.delegate.setLatestLocalPosition(latestLocalPosition);
    }

    public long getBackupPosition() {
        return this.delegate.getBackupPosition();
    }

    public void setBackupPosition(long backupPosition) {
        this.delegate.setBackupPosition(backupPosition);
    }

    public static byte[] serialize(RestoreInfoRequest request) {
        return new SbeRestoreInfoRequest(request).toBytes();
    }

    protected RestoreInfoRequestEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected RestoreInfoRequestDecoder getBodyDecoder() {
        return this.decoder;
    }
}

