/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams.restore;

import io.zeebe.clustering.management.RestoreInfoResponseDecoder;
import io.zeebe.clustering.management.RestoreInfoResponseEncoder;
import io.zeebe.distributedlog.restore.RestoreInfoResponse;
import io.zeebe.distributedlog.restore.impl.DefaultRestoreInfoResponse;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreInfo;
import io.zeebe.engine.util.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class SbeRestoreInfoResponse
extends SbeBufferWriterReader<RestoreInfoResponseEncoder, RestoreInfoResponseDecoder>
implements RestoreInfoResponse {
    private static final RestoreInfoResponse.ReplicationTarget[] ENUM_CONSTANTS = (RestoreInfoResponse.ReplicationTarget[])RestoreInfoResponse.ReplicationTarget.class.getEnumConstants();
    private final RestoreInfoResponseEncoder encoder;
    private final RestoreInfoResponseDecoder decoder;
    private final DefaultRestoreInfoResponse delegate = new DefaultRestoreInfoResponse();

    public SbeRestoreInfoResponse() {
        this.encoder = new RestoreInfoResponseEncoder();
        this.decoder = new RestoreInfoResponseDecoder();
        this.reset();
    }

    public SbeRestoreInfoResponse(RestoreInfoResponse other) {
        this();
        this.setReplicationTarget(other.getReplicationTarget());
        this.setSnapshotRestoreInfo(other.getSnapshotRestoreInfo());
    }

    public SbeRestoreInfoResponse(byte[] serialized) {
        this();
        this.wrap((DirectBuffer)new UnsafeBuffer(serialized));
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.setReplicationTarget(ENUM_CONSTANTS[this.decoder.replicationTarget()]);
        this.setSnapshotRestoreInfo(this.decoder.snapshotId(), this.decoder.numChunks());
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.replicationTarget((short)this.getReplicationTarget().ordinal());
        SnapshotRestoreInfo snapshotRestoreInfo = this.getSnapshotRestoreInfo();
        this.encoder.snapshotId(snapshotRestoreInfo.getSnapshotId());
        this.encoder.numChunks(snapshotRestoreInfo.getNumChunks());
    }

    public RestoreInfoResponse.ReplicationTarget getReplicationTarget() {
        return this.delegate.getReplicationTarget();
    }

    public SnapshotRestoreInfo getSnapshotRestoreInfo() {
        return this.delegate.getSnapshotRestoreInfo();
    }

    public void setReplicationTarget(RestoreInfoResponse.ReplicationTarget replicationTarget) {
        this.delegate.setReplicationTarget(replicationTarget);
    }

    private void setSnapshotRestoreInfo(long snapshotId, int numChunks) {
        this.delegate.setSnapshotRestoreInfo(snapshotId, numChunks);
    }

    private void setSnapshotRestoreInfo(SnapshotRestoreInfo snapshotRestoreInfo) {
        this.delegate.setSnapshotRestoreInfo(snapshotRestoreInfo);
    }

    protected RestoreInfoResponseEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected RestoreInfoResponseDecoder getBodyDecoder() {
        return this.decoder;
    }

    public static byte[] serialize(RestoreInfoResponse response) {
        return new SbeRestoreInfoResponse(response).toBytes();
    }
}

