/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams.restore;

import io.zeebe.clustering.management.SnapshotRestoreRequestDecoder;
import io.zeebe.clustering.management.SnapshotRestoreRequestEncoder;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreRequest;
import io.zeebe.distributedlog.restore.snapshot.impl.DefaultSnapshotRestoreRequest;
import io.zeebe.engine.util.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class SbeSnapshotRestoreRequest
extends SbeBufferWriterReader<SnapshotRestoreRequestEncoder, SnapshotRestoreRequestDecoder>
implements SnapshotRestoreRequest {
    private final SnapshotRestoreRequestEncoder encoder;
    private final SnapshotRestoreRequestDecoder decoder;
    private final DefaultSnapshotRestoreRequest delegate = new DefaultSnapshotRestoreRequest();

    public SbeSnapshotRestoreRequest() {
        this.decoder = new SnapshotRestoreRequestDecoder();
        this.encoder = new SnapshotRestoreRequestEncoder();
        this.reset();
    }

    public SbeSnapshotRestoreRequest(SnapshotRestoreRequest request) {
        this();
        this.setChunkIdx(request.getChunkIdx());
        this.setSnapshotId(request.getSnapshotId());
    }

    public SbeSnapshotRestoreRequest(byte[] bytes) {
        this();
        this.wrap((DirectBuffer)new UnsafeBuffer(bytes));
    }

    public void reset() {
        super.reset();
        this.setSnapshotId(SnapshotRestoreRequestEncoder.snapshotIdNullValue());
        this.setChunkIdx(SnapshotRestoreRequestEncoder.chunkIdxNullValue());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.setSnapshotId(this.decoder.snapshotId());
        this.setChunkIdx(this.decoder.chunkIdx());
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.snapshotId(this.getSnapshotId());
        this.encoder.chunkIdx(this.getChunkIdx());
    }

    private void setChunkIdx(int chunkIdx) {
        this.delegate.setChunkIdx(chunkIdx);
    }

    private void setSnapshotId(long snaphshotId) {
        this.delegate.setSnapshotId(snaphshotId);
    }

    public long getSnapshotId() {
        return this.delegate.getSnapshotId();
    }

    public int getChunkIdx() {
        return this.delegate.getChunkIdx();
    }

    protected SnapshotRestoreRequestEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected SnapshotRestoreRequestDecoder getBodyDecoder() {
        return this.decoder;
    }

    public static byte[] serialize(SnapshotRestoreRequest request) {
        return new SbeSnapshotRestoreRequest(request).toBytes();
    }
}

