/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams.restore;

import io.zeebe.broker.engine.impl.SnapshotChunkImpl;
import io.zeebe.clustering.management.BooleanType;
import io.zeebe.clustering.management.SnapshotRestoreResponseDecoder;
import io.zeebe.clustering.management.SnapshotRestoreResponseEncoder;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreResponse;
import io.zeebe.distributedlog.restore.snapshot.impl.InvalidSnapshotRestoreResponse;
import io.zeebe.distributedlog.restore.snapshot.impl.SuccessSnapshotRestoreResponse;
import io.zeebe.engine.util.SbeBufferWriterReader;
import io.zeebe.logstreams.state.SnapshotChunk;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class SbeSnapshotRestoreResponse
extends SbeBufferWriterReader<SnapshotRestoreResponseEncoder, SnapshotRestoreResponseDecoder>
implements SnapshotRestoreResponse {
    private final SnapshotRestoreResponseEncoder encoder;
    private final SnapshotRestoreResponseDecoder decoder;
    private SnapshotRestoreResponse delegate = new InvalidSnapshotRestoreResponse();
    private DirectBuffer snapshotChunkBuffer = new UnsafeBuffer(0L, 0);

    public SbeSnapshotRestoreResponse() {
        this.encoder = new SnapshotRestoreResponseEncoder();
        this.decoder = new SnapshotRestoreResponseDecoder();
        this.reset();
    }

    public SbeSnapshotRestoreResponse(SnapshotRestoreResponse other) {
        this();
        if (other.isSuccess()) {
            this.delegate = new SuccessSnapshotRestoreResponse(other.getSnapshotChunk());
            byte[] bytes = new SnapshotChunkImpl(other.getSnapshotChunk()).toBytes();
            this.snapshotChunkBuffer.wrap(bytes, 0, bytes.length);
        }
    }

    public SbeSnapshotRestoreResponse(byte[] bytes) {
        this();
        this.wrap((DirectBuffer)new UnsafeBuffer(bytes));
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        boolean valid = this.decoder.success() == BooleanType.TRUE;
        this.decoder.wrapSnapshotChunk(this.snapshotChunkBuffer);
        if (valid) {
            SnapshotChunkImpl snapshotChunk = new SnapshotChunkImpl();
            snapshotChunk.wrap(this.snapshotChunkBuffer);
            this.delegate = new SuccessSnapshotRestoreResponse((SnapshotChunk)snapshotChunk);
        }
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.success(this.delegate.isSuccess() ? BooleanType.TRUE : BooleanType.FALSE);
        this.encoder.putSnapshotChunk(this.snapshotChunkBuffer, 0, this.snapshotChunkBuffer.capacity());
    }

    public SnapshotChunk getSnapshotChunk() {
        return this.delegate.getSnapshotChunk();
    }

    public boolean isSuccess() {
        return this.delegate.isSuccess();
    }

    public static byte[] serialize(SnapshotRestoreResponse response) {
        return new SbeSnapshotRestoreResponse(response).toBytes();
    }

    protected SnapshotRestoreResponseEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected SnapshotRestoreResponseDecoder getBodyDecoder() {
        return this.decoder;
    }

    public int getLength() {
        return super.getLength() + SnapshotRestoreResponseEncoder.snapshotChunkHeaderLength() + this.snapshotChunkBuffer.capacity();
    }
}

