/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.logstreams.state;

import io.zeebe.broker.exporter.stream.ExportersState;
import io.zeebe.db.ZeebeDb;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.logstreams.spi.SnapshotController;
import io.zeebe.util.collection.Tuple;
import org.slf4j.Logger;

public class StatePositionSupplier {
    private final SnapshotController snapshotController;
    private final int partitionId;
    private final String brokerId;
    private final Logger logger;

    public StatePositionSupplier(SnapshotController snapshotController, int partitionId, String brokerId, Logger log) {
        this.snapshotController = snapshotController;
        this.partitionId = partitionId;
        this.brokerId = brokerId;
        this.logger = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple<Long, Long> getLatestPositions() {
        long processedPosition = -1L;
        long exportedPosition = -1L;
        try {
            if (this.snapshotController.getValidSnapshotsCount() > 0) {
                this.snapshotController.recover();
                ZeebeDb zeebeDb = this.snapshotController.openDb();
                processedPosition = this.getLastProcessedPosition(zeebeDb);
                exportedPosition = this.getMinimumExportedPosition(zeebeDb);
            }
        }
        catch (Exception e) {
            this.logger.error("Unexpected error occurred while obtaining the processed and exported position at broker {} for partition {}.", new Object[]{this.brokerId, this.partitionId, e});
        }
        finally {
            try {
                this.snapshotController.close();
            }
            catch (Exception e) {
                this.logger.error("Unexpected error occurred while closing the DB.", (Throwable)e);
            }
        }
        return new Tuple((Object)exportedPosition, (Object)processedPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMinimumExportedPosition() {
        try {
            if (this.snapshotController.getValidSnapshotsCount() > 0) {
                this.snapshotController.recover();
                ZeebeDb zeebeDb = this.snapshotController.openDb();
                long l = this.getMinimumExportedPosition(zeebeDb);
                return l;
            }
        }
        catch (Exception e) {
            this.logger.error("Unexpected error occurred while obtaining the minimum exported position at broker {} for partition {}.", new Object[]{this.brokerId, this.partitionId, e});
        }
        finally {
            try {
                this.snapshotController.close();
            }
            catch (Exception e) {
                this.logger.error("Unexpected error occurred while closing the DB.", (Throwable)e);
            }
        }
        return -1L;
    }

    private long getMinimumExportedPosition(ZeebeDb zeebeDb) {
        ExportersState exporterState = new ExportersState((ZeebeDb<ZbColumnFamilies>)zeebeDb, zeebeDb.createContext());
        if (exporterState.hasExporters()) {
            long lowestPosition = exporterState.getLowestPosition();
            this.logger.debug("The lowest exported position for partition {} at broker {} is {}.", new Object[]{this.partitionId, this.brokerId, lowestPosition});
            return lowestPosition;
        }
        this.logger.debug("No exporters present in snapshot for partition {} at broker {}.", (Object)this.partitionId, (Object)this.brokerId);
        return Long.MAX_VALUE;
    }

    private long getLastProcessedPosition(ZeebeDb zeebeDb) {
        ZeebeState processorState = new ZeebeState(this.partitionId, zeebeDb, zeebeDb.createContext());
        long lowestPosition = processorState.getLastSuccessfulProcessedRecordPosition();
        this.logger.debug("The last processed position for partition {} at broker {} is {}.", new Object[]{this.partitionId, this.brokerId, lowestPosition});
        return lowestPosition;
    }
}

