/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system;

import io.zeebe.broker.clustering.base.ClusterBaseLayerServiceNames;
import io.zeebe.broker.system.Component;
import io.zeebe.broker.system.SystemContext;
import io.zeebe.broker.system.SystemServiceNames;
import io.zeebe.broker.system.configuration.MetricsCfg;
import io.zeebe.broker.system.management.LeaderManagementRequestHandler;
import io.zeebe.broker.system.metrics.MetricsFileWriterService;
import io.zeebe.broker.system.metrics.MetricsHttpServerService;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceContainer;

public class SystemComponent
implements Component {
    @Override
    public void init(SystemContext context) {
        ServiceContainer serviceContainer = context.getServiceContainer();
        MetricsCfg metricsCfg = context.getBrokerConfiguration().getMetrics();
        serviceContainer.createService(SystemServiceNames.METRICS_FILE_WRITER, (Service)new MetricsFileWriterService(metricsCfg)).install();
        if (metricsCfg.isEnableHttpServer()) {
            serviceContainer.createService(SystemServiceNames.METRICS_HTTP_SERVER, (Service)new MetricsHttpServerService(metricsCfg)).install();
        }
        LeaderManagementRequestHandler requestHandlerService = new LeaderManagementRequestHandler();
        serviceContainer.createService(SystemServiceNames.LEADER_MANAGEMENT_REQUEST_HANDLER, (Service)requestHandlerService).dependency(ClusterBaseLayerServiceNames.ATOMIX_SERVICE, requestHandlerService.getAtomixInjector()).groupReference(ClusterBaseLayerServiceNames.LEADER_PARTITION_GROUP_NAME, requestHandlerService.getLeaderPartitionsGroupReference()).install();
    }
}

