/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.configuration;

import com.google.gson.GsonBuilder;
import io.zeebe.broker.exporter.debug.DebugLogExporter;
import io.zeebe.broker.system.configuration.ClusterCfg;
import io.zeebe.broker.system.configuration.DataCfg;
import io.zeebe.broker.system.configuration.EmbeddedGatewayCfg;
import io.zeebe.broker.system.configuration.ExporterCfg;
import io.zeebe.broker.system.configuration.MetricsCfg;
import io.zeebe.broker.system.configuration.NetworkCfg;
import io.zeebe.broker.system.configuration.ThreadsCfg;
import io.zeebe.util.Environment;
import java.util.ArrayList;
import java.util.List;

public class BrokerCfg {
    private NetworkCfg network = new NetworkCfg();
    private ClusterCfg cluster = new ClusterCfg();
    private ThreadsCfg threads = new ThreadsCfg();
    private MetricsCfg metrics = new MetricsCfg();
    private DataCfg data = new DataCfg();
    private List<ExporterCfg> exporters = new ArrayList<ExporterCfg>();
    private EmbeddedGatewayCfg gateway = new EmbeddedGatewayCfg();

    public void init(String brokerBase) {
        this.init(brokerBase, new Environment());
    }

    public void init(String brokerBase, Environment environment) {
        this.applyEnvironment(environment);
        this.network.init(this, brokerBase, environment);
        this.cluster.init(this, brokerBase, environment);
        this.threads.init(this, brokerBase, environment);
        this.metrics.init(this, brokerBase, environment);
        this.data.init(this, brokerBase, environment);
        this.exporters.forEach(e -> e.init(this, brokerBase, environment));
        this.gateway.init(this, brokerBase, environment);
    }

    private void applyEnvironment(Environment environment) {
        environment.get("ZEEBE_DEBUG").ifPresent(value -> this.exporters.add(DebugLogExporter.defaultConfig("pretty".equalsIgnoreCase((String)value))));
    }

    public NetworkCfg getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkCfg network) {
        this.network = network;
    }

    public ClusterCfg getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterCfg cluster) {
        this.cluster = cluster;
    }

    public ThreadsCfg getThreads() {
        return this.threads;
    }

    public void setThreads(ThreadsCfg threads) {
        this.threads = threads;
    }

    public MetricsCfg getMetrics() {
        return this.metrics;
    }

    public void setMetrics(MetricsCfg metrics) {
        this.metrics = metrics;
    }

    public DataCfg getData() {
        return this.data;
    }

    public void setData(DataCfg logs) {
        this.data = logs;
    }

    public List<ExporterCfg> getExporters() {
        return this.exporters;
    }

    public void setExporters(List<ExporterCfg> exporters) {
        this.exporters = exporters;
    }

    public EmbeddedGatewayCfg getGateway() {
        return this.gateway;
    }

    public BrokerCfg setGateway(EmbeddedGatewayCfg gateway) {
        this.gateway = gateway;
        return this;
    }

    public String toString() {
        return "BrokerCfg{network=" + this.network + ", cluster=" + this.cluster + ", threads=" + this.threads + ", metrics=" + this.metrics + ", data=" + this.data + ", exporters=" + this.exporters + ", gateway=" + this.gateway + '}';
    }

    public String toJson() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }
}

