/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.configuration;

import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.ConfigurationEntry;
import io.zeebe.util.Environment;
import java.util.Collections;
import java.util.List;
import org.agrona.collections.IntArrayList;

public class ClusterCfg
implements ConfigurationEntry {
    public static final List<String> DEFAULT_CONTACT_POINTS = Collections.emptyList();
    public static final int DEFAULT_NODE_ID = 0;
    public static final int DEFAULT_PARTITIONS_COUNT = 1;
    public static final int DEFAULT_REPLICATION_FACTOR = 1;
    public static final int DEFAULT_CLUSTER_SIZE = 1;
    public static final String DEFAULT_CLUSTER_NAME = "zeebe-cluster";
    private List<String> initialContactPoints = DEFAULT_CONTACT_POINTS;
    private List<Integer> partitionIds;
    private int nodeId = 0;
    private int partitionsCount = 1;
    private int replicationFactor = 1;
    private int clusterSize = 1;
    private String clusterName = "zeebe-cluster";

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase, Environment environment) {
        this.applyEnvironment(environment);
        this.initPartitionIds();
    }

    private void initPartitionIds() {
        IntArrayList list = new IntArrayList();
        int i = 1;
        while (i < 1 + this.partitionsCount) {
            int partitionId = i++;
            list.add(Integer.valueOf(partitionId));
        }
        this.partitionIds = Collections.unmodifiableList(list);
    }

    private void applyEnvironment(Environment environment) {
        environment.getInt("ZEEBE_NODE_ID").ifPresent(v -> {
            this.nodeId = v;
        });
        environment.getInt("ZEEBE_CLUSTER_SIZE").ifPresent(v -> {
            this.clusterSize = v;
        });
        environment.get("ZEEBE_CLUSTER_NAME").ifPresent(v -> {
            this.clusterName = v;
        });
        environment.getInt("ZEEBE_PARTITIONS_COUNT").ifPresent(v -> {
            this.partitionsCount = v;
        });
        environment.getInt("ZEEBE_REPLICATION_FACTOR").ifPresent(v -> {
            this.replicationFactor = v;
        });
        environment.getList("ZEEBE_CONTACT_POINTS").ifPresent(v -> {
            this.initialContactPoints = v;
        });
    }

    public List<String> getInitialContactPoints() {
        return this.initialContactPoints;
    }

    public void setInitialContactPoints(List<String> initialContactPoints) {
        this.initialContactPoints = initialContactPoints;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    public void setPartitionsCount(int partitionsCount) {
        this.partitionsCount = partitionsCount;
    }

    public List<Integer> getPartitionIds() {
        return this.partitionIds;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public void setClusterSize(int clusterSize) {
        this.clusterSize = clusterSize;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String toString() {
        return "ClusterCfg{nodeId=" + this.nodeId + ", partitionsCount=" + this.partitionsCount + ", replicationFactor=" + this.replicationFactor + ", clusterSize=" + this.clusterSize + ", initialContactPoints=" + this.initialContactPoints + '}';
    }
}

