/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.configuration;

import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.ConfigurationEntry;
import io.zeebe.broker.system.configuration.ConfigurationUtil;
import io.zeebe.util.Environment;
import java.util.Arrays;
import java.util.List;

public class DataCfg
implements ConfigurationEntry {
    public static final String DEFAULT_DIRECTORY = "data";
    private List<String> directories = Arrays.asList("data");
    private String logSegmentSize = "512M";
    private String indexBlockSize = "4M";
    private String snapshotPeriod = "15m";
    private String snapshotReplicationPeriod = "5m";
    private String raftSegmentSize;
    private int maxSnapshots = 1;

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase, Environment environment) {
        this.applyEnvironment(environment);
        this.directories.replaceAll(d -> ConfigurationUtil.toAbsolutePath(d, brokerBase));
    }

    private void applyEnvironment(Environment environment) {
        environment.getList("ZEEBE_DIRECTORIES").ifPresent(v -> {
            this.directories = v;
        });
    }

    public List<String> getDirectories() {
        return this.directories;
    }

    public void setDirectories(List<String> directories) {
        this.directories = directories;
    }

    public String getLogSegmentSize() {
        return this.logSegmentSize;
    }

    public void setLogSegmentSize(String logSegmentSize) {
        this.logSegmentSize = logSegmentSize;
    }

    public String getIndexBlockSize() {
        return this.indexBlockSize;
    }

    public void setIndexBlockSize(String indexBlockSize) {
        this.indexBlockSize = indexBlockSize;
    }

    public String getSnapshotPeriod() {
        return this.snapshotPeriod;
    }

    public void setSnapshotPeriod(String snapshotPeriod) {
        this.snapshotPeriod = snapshotPeriod;
    }

    public String getSnapshotReplicationPeriod() {
        return this.snapshotReplicationPeriod;
    }

    public void setSnapshotReplicationPeriod(String snapshotReplicationPeriod) {
        this.snapshotReplicationPeriod = snapshotReplicationPeriod;
    }

    public void setMaxSnapshots(int maxSnapshots) {
        this.maxSnapshots = maxSnapshots;
    }

    public int getMaxSnapshots() {
        return this.maxSnapshots;
    }

    public String getRaftSegmentSize() {
        return this.raftSegmentSize;
    }

    public void setRaftSegmentSize(String raftSegmentSize) {
        this.raftSegmentSize = raftSegmentSize;
    }

    public String toString() {
        return "DataCfg{directories=" + this.directories + ", logSegmentSize='" + this.logSegmentSize + '\'' + ", indexBlockSize='" + this.indexBlockSize + '\'' + ", snapshotPeriod='" + this.snapshotPeriod + '\'' + ", snapshotReplicationPeriod='" + this.snapshotReplicationPeriod + '\'' + ", maxSnapshots='" + this.maxSnapshots + '\'' + '}';
    }
}

